my $gsdlhome = shift(@ARGV);

use ExtUtils::MakeMaker;

# Don't try to descend into Expat directory for testing

sub MY::test
{
  my $self = shift;

  my $hold = delete $self->{DIR};
  my $ret = $self->MM::test(@_);
  $self->{DIR} = $hold if defined($hold);
  $ret;
}

@extras = ();

push(@extras,
     CAPI => 'TRUE')
    if ($PERL_VERSION >= 5.005 and $OSNAME eq 'MSWin32'
	and $Config{archname} =~ /-object\b/i);

push(@extras,
     ABSTRACT_FROM => 'Parser.pm',
     AUTHOR        => 'Clark Cooper (coopercc@netheaven.com)')
    if ($ExtUtils::MakeMaker::Version >= 5.4301);

push(@extras, CC => $ENV{'CC'})
    if (defined $ENV{'CC'});

push(@extras, LD => $ENV{'LD'})
    if (defined $ENV{'LD'});
     
WriteMakefile(
              NAME	=> 'XML::Parser',
	      DIR	=> [qw(Expat)],
	      INSTALLSITELIB  => "$gsdlhome/perllib/cpan",
	      PREFIX    => "$gsdlhome/perllib/cpan/XML",
              INSTALLMAN1DIR => "$gsdlhome/perllib/cpan",
              INSTALLMAN3DIR => "$gsdlhome/perllib/cpan",
              SITEPREFIX => "$gsdlhome/perllib/cpan",
              dist      => {COMPRESS => 'gzip', SUFFIX => '.gz'},
              VERSION_FROM => 'Parser.pm',
	      OPTIMIZE => ' ',
	      CCCDLFLAGS => ' ',
	      @extras
             );

