/**********************************************************************
 *
 * z3950server.h --
 * Copyright (C) 2000  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef Z3950SERVER_H
#define Z3950SERVER_H

#include <string>
#include <list>

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>

// Greenstone headers
#include "fileutil.h"

// the maximum number of hits allowed
#define MAXHITS 10000

// These globals are local to each thread: one Z39.50 connection = one thread.

extern text_t gsdlhome; // this is specified externally when Greenstone is installed
extern list<FilterResponse_t> Response_tlist; // list of response sets
extern list<text_t> Response_tlist_colnames;  // collection names for the above
extern list<int> Response_tlist_sizes;        // sizes (number of records) for the above
extern z3950Server *Server;
extern collectset *Cservers;
extern nullproto *Protocol;
extern map<text_t, gsdlCollection> Collection_map; // info and tools for collections
extern map<text_t, text_t> Resultsets;             // mapping from ResultSetId to GSQuery 

extern int z3950_verbosity_;

bend_initresult *bend_init(bend_initrequest *q);
void bend_close(void *handle);

Z_GenericRecord *read_grs1(FILE *f, ODR o);

int ztest_search (void *handle, bend_search_rr *rr);
int ztest_sort (void *handle, bend_sort_rr *rr);
int ztest_present (void *handle, bend_present_rr *rr);
int ztest_esrequest (void *handle, bend_esrequest_rr *rr);
int ztest_delete (void *handle, bend_delete_rr *rr);
int ztest_fetch(void *handle, bend_fetch_rr *r);
int ztest_scan(void *handle, bend_scan_rr *q);


#endif
