#!/bin/sh
#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
#
# Usage: install-bindist.sh [ServerRoot]
# This script installs the Apache binary distribution and
# was automatically created by binbuild.sh.


##
##  determine path to (optional) Perl interpreter
##
PERL=no-perl5-on-this-system
perls='perl5 perl'
path=`echo $PATH | sed -e 's/:/ /g'`
found_perl=0
 
for dir in ${path} ;  do
  for pperl in ${perls} ; do
    if test -f "${dir}/${pperl}" ; then
      if `${dir}/${pperl} -v >/dev/null 2>&1` ; then
        PERL="${dir}/${pperl}"
        found_perl=1
        break
      fi
    fi
  done
  if test $found_perl = 1 ; then
    break
  fi
done
 
if [ "x$1" = "x" ]
then
  echo "Number of arguments should be 1. Provide the root directory for the web server."
  exit 1
else
  SR="$1"
fi

# we're the ones putting the apache httpd together, including the envvars file
# so we can over-write it
if [ -f "$SR/bin/envvars" ]
then
  echo "[Preserving existing envvars settings.]"
  HAD_ENVVARS=yes
else
  HAD_ENVVARS=no
fi

# Need to run this script from its own directory 
# instead of whatever directory it may be called from
#currentdir=$(cd `dirname "$0"` && pwd)
currentdir="`dirname \"$0\"`"
currentdir="`cd \"$currentdir\" && pwd`"
cd "$currentdir"

sed -e "s%\*\*APACHE_HOME_OS\*\*%$SR%" "$SR/conf/httpd.conf.in" > "$SR/conf/httpd.conf"

sed -e "s;^#!\@perlbin\@.*;#!$PERL;" -e "s;\@exp_installbuilddir\@;$SR/build;" \
	apxs.in > "$SR/bin/apxs"

# usually we're updating existing files, so need to copy them over into tmp files first
#PRE=`grep "^prefix = " build/config_vars.mk`
#PRE=`echo $PRE | sed -e "s;prefix = ;;"`
sed -e "s%\*\*APACHE_HOME_OS\*\*%$SR%" build/config_vars.mk.in > "$SR/build/config_vars.mk.tmp"
mv "$SR/build/config_vars.mk.tmp" "$SR/build/config_vars.mk"
chmod u+rwx "$SR/build/config_vars.mk"

sed -e "s;^#!/.*;#!$PERL;" bin/dbmmanage.in > "$SR/bin/dbmmanage.tmp"
mv "$SR/bin/dbmmanage.tmp" "$SR/bin/dbmmanage"

# IMPORTANT: need to insert the ServerRoot nested inside quotes into the apachectl file
#cp bin/apachectl.in bin/apachectl
sed -e "s%\*\*APACHE_HOME_OS\*\*/bin/envvars%\"$SR/bin/envvars\"%" \
    -e "s%\*\*APACHE_HOME_OS\*\*%\"$SR\"%" \
    -e "s%^HTTPD=.*$%HTTPD=\"$SR/bin/httpd\"%" \
    -e "s%\$HTTPD%\$HTTPD -d \"$SR\"%" bin/apachectl.in > "$SR/bin/apachectl.tmp"
mv "$SR/bin/apachectl.tmp" "$SR/bin/apachectl"
chmod u+rwx "$SR/bin/apachectl"

sed -e "s%\*\*APACHE_HOME_OS\*\*%$SR%" \
        bin/envvars-std.in > "$SR/bin/envvars-std.tmp"
mv "$SR/bin/envvars-std.tmp" "$SR/bin/envvars-std"
chmod u+rwx "$SR/bin/envvars-std"

if [ $HAD_ENVVARS = no ]
then
    cp -p "$SR/bin/envvars-std" "$SR/bin/envvars.in"
fi
# Either way, do a find and replace on APACHE_HOME_OS in the envvars file
sed -e "s%\*\*APACHE_HOME_OS\*\*%$SR%" "$SR/bin/envvars.in" > "$SR/bin/envvars.tmp"
mv "$SR/bin/envvars.tmp" "$SR/bin/envvars"


# Non-crucial files (replacements not essential)
# but replacing the occurrences of $PRE in them with $SR anyway:
REPLACELIST="conf/extra/httpd-dav.conf conf/extra/httpd-manual.conf conf/extra/httpd-autoindex.conf conf/extra/httpd-vhosts.conf conf/extra/httpd-ssl.conf conf/extra/httpd-multilang-errordoc.conf conf/original/extra/httpd-dav.conf conf/original/extra/httpd-manual.conf conf/original/extra/httpd-autoindex.conf conf/original/extra/httpd-vhosts.conf conf/original/extra/httpd-ssl.conf conf/original/extra/httpd-multilang-errordoc.conf conf/original/httpd.conf lib/apr-util-1/apr_dbd_odbc.la lib/apr-util-1/apr_dbd_sqlite3.la lib/pkgconfig/apr-util-1.pc lib/pkgconfig/apr-1.pc lib/libaprutil-1.la lib/libapr-1.la build/config_vars.mk build/config.nice build/apr_rules.mk bin/apu-1-config bin/apr-1-config include/ap_config_auto.h include/ap_config_layout.h"

for one_file in $REPLACELIST; do
    if [ -f $one_file ]; then
        sed -e "s%\*\*APACHE_HOME_OS\*\*%$SR%" "$one_file.in" > "$one_file.tmp"
        mv $one_file.tmp $one_file
        chmod u+w $one_file
    fi
done

echo "Ready."
echo " +--------------------------------------------------------+"
echo " | You now have successfully installed the Apache         |"
echo " | HTTP server. To verify that Apache actually works      |"
echo " | correctly you should first check the (initially        |"
echo " | created or preserved) configuration files:             |"
echo " |                                                        |"
echo " |   $SR/conf/httpd.conf"
echo " |                                                        |"
echo " | You should then be able to immediately fire up         |"
echo " | Apache the first time by running:                      |"
echo " |                                                        |"
echo " |   $SR/bin/apachectl start "
echo " |                                                        |"
echo " | Thanks for using Apache.       The Apache Group        |"
echo " |                                http://www.apache.org/  |"
echo " +--------------------------------------------------------+"
echo " "
