# this file must be UTF-8 encoded
######################################################################
#
# Catalan Language text and icon macros 
# -- this file contains text that is of less importance
# -- to translate when creating a new interface language
######################################################################

######################################################################
# 'home' page
package home
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_documents_ [l=ca] {documents. }
_lastupdate_ [l=ca] {Última actualització}
_ago_ [l=ca] {dies enrere.}
_colnotbuilt_ [l=ca] {Col·lecció no construïda.}

### taken from here

_textpoem_ [l=ca] {<br><h2>Kia papapounamu te moana</h2>

<p>kia hora te marino,
<br>kia tere te karohirohi,
<br>kia papapounamu te moana

<p>que la pau i la calma t'envoltin,
<br>que visquis en la calidesa de la calitja d'estiu,
<br>que l'oceà dels teus viatges sigui tan llis com la pedra verda polida.
}

_textgreenstone_ [l=ca] {<p>Greenstone (pedra verda) és una pedra semipreciosa que (com aquest programari) procedeix de Nova Zelanda. A la societat tradicional dels maoris, era la substància més preuada i cobejada de totes. Pot absorbir i conservar el <i>wairua</i>, que és un esperit o força vital, i està dotada de virtuts tradicionals que la converteixen en un emblema escaient per a un projecte de biblioteca digital de domini públic. La seva brillantor representa la caritat; la seva transparència, l'honestedat; la seva duresa, el coratge; i el tall esmolat que pot adquirir, la justícia. La talla de pedra que apareix en el logotip de la Biblioteca Digital de Greenstone és un <i>patu</i>, una mena de porra de lluita, i una herència familiar d'un dels components del projecte. En un combat cos a cos, la seva escomesa era molt ràpida, precisa i completa. Hem volgut conferir aquestes mateixes qualitats al nostre programari, i que el tall esmolat del <i>patu</i> simbolitzi l'aspecte avançat i avantguardista de la tecnologia.  }

_textaboutgreenstone_ [l=ca] {<p>Greenstone és un conjunt de programes informàtics per a la construcció i difusió de col·leccions de biblioteca digital. Proporciona una nova forma d'organitzar la informació i de publicar-la a Internet o en cd-rom. Elaborat pel <b>Projecte de Biblioteca Digital de Nova Zelanda</b> a la <b>Universitat de Waikato</b>, es distribueix en col·laboració amb la <b>UNESCO</b> i la <b>ONG Human Info </b>.  És un programari de codi font obert que es pot obtenir a <a
href="http://greenstone.org">http://greenstone.org</a> d'acord amb les condicions de la Llicència Pública General GNU. 
<p>L'objectiu del programari és que els usuaris, especialment en universitats, biblioteques i altres institucions de servei públic, puguin crear les seves pròpies biblioteques digitals. Aquestes biblioteques estan transformant radicalment el mètode de distribució i adquisició de coneixements utilitzat per la UNESCO amb els seus interlocutors en els camps de l'educació, la ciència i la cultura arreu del món, i molt especialment als països en vies de desenvolupament.  El nostre desig és que aquest programari estimuli l'ús efectiu de les biblioteques digitals per compartir informació i posar-la a disposició del públic en general. 

<p>Aquest programari s'elabora i es distribueix gràcies a una iniciativa de cooperació internacional acordada l'agost del 2000 entre tres institucions.

<table border="0">
<tr valign="top">
<td>
<a href="http://nzdl.org"><b>Projecte de Biblioteca Digital de Nova Zelanda a la Universitat de Waikato</b></a>
<br>
El programari de Greenstone ha sorgit d'aquest projecte i la iniciativa ha rebut el suport de la Subcomissió de Comunicació de la Comissió Nacional de Nova Zelanda per a la UNESCO com a part de la contribució de Nova Zelanda al programa de la UNESCO. 
</td>
<td></td>
</tr>
<tr valign="top">
<td>
<a href="http://www.unesco.org"><b>Organització de Nacions Unides per a l'Educació, la Ciència i la Cultura (UNESCO)</b></a>
<br>
La difusió mundial d'informació en matèria d'educació, ciència i cultura, especialment en els països en vies de desenvolupament, és un dels objectius principals de la UNESCO, que la duu a terme mitjançant el programa intergovernamental "Informació per a tothom". Amb aquest fi, es consideren eines importants la informació apropiada i de fàcil accés i la tecnologia de la comunicació.
</td>
<td><a href="http://www.unesco.org"><img alt="UNESCO logo" src="_httpimg_/unesco.gif"
border="0"></a></td>
</tr>
<tr valign="top">
<td>
<a href="http://humaninfo.org"><b>L'ONG Human Info, amb seu a Anvers, Bèlgica</b></a>
<br>
Aquest projecte, impulsat per organismes de l'ONU i altres ONG, gaudeix de prestigi mundial per la seva tasca de digitalitzar documentació d'interès per al desenvolupament humà i donar-hi difusió pública, de manera gratuïta per als països en desenvolupament i a preu de cost per als països desenvolupats.  </td>
<td><a href="http://humaninfo.org"><img alt="Human Info logo" src="_httpimg_/ghproj2.jpg" border="0"></a></td>
</tr>
</table>
}

_textdescrselcol_ [l=ca] {seleccioneu una col·lecció}

######################################################################
# home help page
package homehelp
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_text4buts_ [l=ca] {Hi ha quatre botons més a la pàgina principal}

_textnocollections_ [l=ca] {<p>Actualment no hi ha cap col·lecció disponible en aquesta instal·lació de Greenstone.  
Per afegir col·leccions, podeu: 
<ul><li>Utilitzar<a href="_httppagecollector_">el col·leccionista</a> per construir noves col·leccions
    <li>Si teniu un cd-rom de Greenstone, podeu instal·lar col·leccions des del cd-rom 
</ul>
}

_text1coll_ [l=ca] {Aquesta instal·lació de Greenstone conté 1 col·lecció}

_textmorecolls_ [l=ca] {Aquesta instal·lació de Greenstone conté _1_ col·leccions}

######################################################################
# external link package
package extlink
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textextlink_ [l=ca] {Enllaç extern}
_textlinknotfound_ [l=ca] {No s'ha trobat l'enllaç intern}

_textextlinkcontent_ [l=ca] {L'enllaç que heu seleccionat és extern a qualsevol de les vostres col·leccions seleccionades actualment.
    Si encara voleu visualitzar aquest enllaç i el vostre navegador té accés a la web, podeu <a href="_nexturl_" onClick="follow\_escaped\_link(event, this.href)">avançar</a> fins a aquesta pàgina; en cas contrari, pitgeu el botó "retrocés" per tornar al document anterior. }

_textlinknotfoundcontent_ [l=ca] {L'enllaç intern que heu seleccionat no existeix. Això es deu segurament a un error a la col·lecció font. Pitgeu el botó "retrocés" per tornar al document anterior. }

# should have arguments of collection, collectionname and link
_foundintcontent_ [l=ca] {<h3>Enllaç amb la col·lecció "_2_" </h3>  <p> L'enllaç que heu seleccionat és extern a la col·lecció "_collectionname_"     (connecta amb la col·lecció "_2_").     Si voleu visualitar aquest enllaç a la col·lecció "_2_" podeu       <a href="_httpdoc_&c=_1_&cl=_cgiargclUrlsafe_&d=_3_">avançar</a> fins a aquesta pàgina;      en cas contrari, pitgeu el botó "retrocés" del vostre navegador per tornar al document anterior. }

######################################################################
# authentication page
package authen
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textGSDLtitle_ [l=ca] {Biblioteca Digital de Greenstone}

_textusername_ [l=ca] {nom d'usuari}
_textpassword_ [l=ca] {contrasenya}

_textmustbelongtogroup_ [l=ca] {Avís: heu de pertànyer al grup "_cgiargugHtmlsafe_" per entrar a aquesta pàgina}

_textmessageinvalid_ [l=ca] {La pàgina que heu demanat exigeix que us identifiqueu.<br>
_If_(_cgiargug_,[_textmustbelongtogroup_]<br>)
Introduïu el nom d'usuari i la contrasenya de Greenstone.}

_textmessagefailed_ [l=ca] {Hi ha un error en el nom d'usuari o la contrasenya.}

_textmessagedisabled_ [l=ca] {Disculpeu, el vostre compte ha estat inhabilitat. Poseu-vos en contacte amb l'administrador d'aquest lloc web.}

_textmessagepermissiondenied_ [l=ca] {Disculpeu, però no teniu permís per entrar a aquesta pàgina.}

_textmessagestalekey_ [l=ca] {L'enllaç que heu seguit ja no és vàlid. Introduïu la contrasenya per entrar a aquesta pàgina. }

######################################################################
# 'docs' page 
package docs
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textnodocumentation_ [l=ca] {<p>Aquesta instal·lació de Greenstone no conté cap tipus de documentació. Això pot ser perquè: 
<ol>
 <li>Greenstone es va instal·lar a partir d'un cd-rom en versió compacta.
 <li>Greenstone es va instal·lar a partir d'una distribució baixada d'Internet.
</ol>
En qualsevol cas, podeu obtenir la documentació al directori <i>docs</i>
d'un cd-rom de Greenstone o a la web <a
href="http://www.greenstone.org">http://www.greenstone.org</a>.
}

_textuserguide_ [l=ca] {Guia de l'usuari}
_textinstallerguide_ [l=ca] {Guia de l'instal·lador}
_textdeveloperguide_ [l=ca] {Guia del programador}
_textpaperguide_ [l=ca] {Del paper a la col·lecció }
_textorganizerguide_ [l=ca] {Ús de l'organitzador}

_textgsdocstitle_ [l=ca] {documentació de Greenstone}

######################################################################
# collectoraction
package wizard

_textbild_ [l=ca] {Construeix col·lecció}
_textbildsuc_ [l=ca] {Col·lecció construïda satisfactòriament. }
_textviewbildsummary_ [l=ca] {Podeu <a href="_httppagex_(bsummary)" target=_top>visualitzar el resum de construcció</a> d'aquesta col·lecció per més detalls. }
_textview_ [l=ca] {Visualitza la col·lecció}

_textbild1_ [l=ca] {La col·lecció s'està construint: això pot durar uns instants. La línia d'estat de la construcció dóna informació sobre el progrés de l'operació.  }

_textbild2_ [l=ca] {Per aturar el procés de construcció en qualsevol moment, feu clic aquí.  <br>La col·lecció amb què esteu treballant quedarà intacta.  }

_textstopbuild_ [l=ca] {para la construcció}

_textbild3_ [l=ca] {Si sortiu d'aquesta pàgina (i no heu cancel·lat el procés de construcció amb  el botó "atura la construcció") la construcció continuarà i  s'instal·larà un cop completat satisfactòriament el procés. }

_textbuildcancelled_ [l=ca] {Construcció cancel·lada}

_textbildcancel1_ [l=ca] {S'ha cancel·lat el procés de construcció. Utilitzeu els botons grocs a sota per fer canvis a la col·lecció o reiniciar el procés de construcció. }

_textbsupdate1_ [l=ca] {Actualització d'estat de construcció d'aquí a 1 segon}
_textbsupdate2_ [l=ca] {Actualització d'estat de construcció d'aquí a}
_textseconds_ [l=ca] {segons}

_textfailmsg11_ [l=ca] {La col·lecció no s'ha pogut construir perquè no conté dades. Comproveu que existeixi   almenys un dels directoris o fitxers que heu especificat a la pàgina de <i>dades font</i> i que sigui d'un tipus o (en el cas d'un directori)  que contingui fitxers d'un tipus que Greenstone pugui processar.  }

_textfailmsg21_ [l=ca] {No s'ha pogut construir la col·lecció (ha fallat import.pl).}
_textfailmsg31_ [l=ca] {No s'ha pogut construir la col·lecció (ha fallat buildcol.pl).}
_textfailmsg41_ [l=ca] {La col·lecció s'ha construït satisfactòriament però no s'ha pogut instal·lar.}
_textfailmsg71_ [l=ca] {Hi ha hagut un error inesperat mentre s'intentava construir la col·lecció}

_textblcont_ [l=ca] {El registre de construcció conté la informació següent:}

######################################################################
# collectoraction
package collector
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdefaultstructure_ [l=ca] {estructura per defecte}
_textmore_ [l=ca] {més}
_textinfo_ [l=ca] {Informació de la col·lecció}
_textsrce_ [l=ca] {Dades font}
_textconf_ [l=ca] {Configura la col·lecció}
_textdel_ [l=ca] {Suprimeix la col·lecció}
_textexpt_ [l=ca] {Exporta la col·lecció}

_textdownloadingfiles_ [l=ca] {Està baixant fitxers...}
_textimportingcollection_ [l=ca] {Està important la col·lecció...}
_textbuildingcollection_ [l=ca] {Està construint la col·lecció... }
_textcreatingcollection_ [l=ca] {està creant la col·lecció...}

_textcollectorblurb_ [l=ca] {<i>La ploma té més força que l'espasa!
<br>Construir i distribuir col·leccions d'informació implica responsabilitats que cal plantejar-se detingudament abans de començar. Hi ha qüestions legals de drets d'autor: tenir accés a documents no significa necessàriament que els pugueu posar a disposició de terceres persones. 
Hi ha qüestions socials: les col·leccions han de respectar els costums de la societat de la qual provenen els documents.
I hi ha qüestions ètiques: hi ha coses que simplement no es poden posar a disposició de terceres persones. 
<br>Tingueu molt en compte el poder de la informació i feu-la servir amb prudència.
</i>
}

_textcb1_ [l=ca] {El "col·leccionista" us ajuda a crear noves col·leccions, modificar les que ja existeixen o afegir-hi elements i suprimir col·leccions. Per dur a terme aquestes tasques, us guiarà per una seqüència de pàgines web que us demanaran la informació necessària. }

_textcb2_ [l=ca] {Primer heu de decidir si}
_textcnc_ [l=ca] {crea una nova col·lecció}
_textwec_ [l=ca] {treballar amb una d'existent, afegint-hi dades o suprimint-la. }

_textcb3_ [l=ca] {Per construir o modificar col·leccions de la biblioteca digital, us heu d'identificar. Això és per protegir-vos d'altres persones que vulguin entrar al vostre ordinador i alterar-ne la informació. Nota: per raons de seguretat, us haureu d'identificar cada 30 minuts. Quan passi això, no us preocupeu!  Una vegada identificats, podreu continuar allà on ho havíeu deixat. }

_textcb4_ [l=ca] {Introduïu els vostre nom d'usuari i la contrasenya de Greenstone i pitgeu el botó per entrar.}

_textfsc_ [l=ca] {En primer lloc, seleccioneu la col·lecció amb què voleu treballar (les col·leccions protegides contra escriptura no apareixeran en aquesta llista). }

_textwtc_ [l=ca] {Amb la col·lecció que heu seleccionat, podeu}
_textamd_ [l=ca] {Afegeix més dades i torna a construir la col·lecció}
_textetc_ [l=ca] {Modificar el fitxer de configuració de la col·lecció i tornar-la a construir }
_textdtc_ [l=ca] {Suprimeix tota la col·lecció}
_textetcfcd_ [l=ca] {Exportar la col·lecció per gravar-la en un cd-rom que s'instal·li automàticament a Windows}
_textcaec_ [l=ca] {Canviar una col·lecció existent}
_textnwec_ [l=ca] {No hi ha disponible per a modificació cap col·lecció que permeti l'escriptura }
_textcianc_ [l=ca] {Crear una nova col·lecció}
_texttsosn_ [l=ca] {La seqüència de passos necessaris per crear una nova col·lecció a la biblioteca digital és:}
_textsin_ [l=ca] {N'especifica el nom (i dades associades)}
_textswts_ [l=ca] {Especifica d'on procedeixen les dades font}
_textatco_ [l=ca] {Ajusta les opcions de configuració (només per a usuaris avançats)}
_textbtc_ [l=ca] {"Construir" la col·lecció (vegeu més avall)}
_textpvyh_ [l=ca] {Admireu la vostra obra!}

_texttfsiw_ [l=ca] {El quart pas és quan l'ordinador fa tota la feina. Durant el procés de "construcció", l'ordinador crea tots els índexs i recopila tota la informació necessària perquè el sistema funcioni. Però primer cal que especifiqueu la informació. }

_textadab_ [l=ca] {A sota apareix un diagrama que us ajudarà a saber on us trobeu. Pitgeu el botó verd per continuar avançant per la seqüència. Quan avanceu, els botons es tornaran de color groc. Podeu tornar a la pàgina anterior pitjant el botó groc corresponent al diagrama. }

_textwyar_ [l=ca] {Quan estigueu a punt, pitgeu el botó verd "informació de la col·lecció" per començar a crear la nova col·lecció de la biblioteca digital. }

_textcnmbs_ [l=ca] {Cal especificar el nom de la col·lecció}
_texteambs_ [l=ca] {Cal especificar l'adreça de correu electrònic}
_textpsea_ [l=ca] {Comproveu que l'adreça de correu electrònic correspongui al format usuari@domini}
_textdocmbs_ [l=ca] {Cal especificar la descripció de la col·lecció}

_textwcanc_ [l=ca] {En crear una nova col·lecció caldrà incorporar algunes informacions preliminars sobre les dades font. Aquest procés està estructurat en forma d'una sèrie de pàgines web, supervisades pel col·leccionista. La barra al peu de la pàgina us mostra la seqüència de pàgines que s'han d'emplenar.}

_texttfc_ [l=ca] {Títol de la col·lecció:}

_texttctiasp_ [l=ca] {El títol de la col·lecció és una frase curta que servirà per identificar el contingut de la col·lecció en tota la biblioteca digital. Per exemple, "Informes tècnics d'informàtica" o "Biblioteca per al desenvolupament de la humanitat".}

_textcea_ [l=ca] {Adreça electrònica de contacte:}

_textteas_ [l=ca] {Aquesta adreça de correu electrònic constitueix el primer punt de contacte per a la col·lecció. Si el programari de Greenstone detecta un problema, envia un informe diagnòstic a aquesta adreça. Escriviu una adreça de correu electrònic en la seva forma completa: <tt>nom@domini</tt>.}

_textatc_ [l=ca] {Sobre aquesta col·lecció:}

_texttiasd_ [l=ca] {Això és un enunciat que descriu els principis que regeixen els elements que formen part d'aquesta col·lecció. Apareixerà a la pimera pàgina de presentació de la col·lecció.   }

_textypits_ [l=ca] {La vostra posició a la seqüència s'indica amb una fletxa per sota--en aquest cas, la fase d'"informació de la col·lecció". Per continuar, pitgeu el botó verd "dades font". }

_srcebadsources_ [l=ca] {<p>Un o més dels fitxers font que heu especificat no està disponible (marcats _iconcross_ a sota).

<p>Això pot ser perquè <ul>
<li>El fitxer, el lloc FTP o l'URL no existeixen.
<li>Primer us heu de connectar a Internet.
<li>Esteu intentant accedir a un URL protegit per un tallafoc (això passa si normalment heu de donar un nom d'usuari i una contrasenya per accedir a Internet).
</ul>

<p>Si aquest és un URL que podeu veure en el vostre navegador, el problema podria venir d'una còpia que es trobi a la memòria cau local. Malauradament, aquestes còpies són invisibles per al procés de rèplica de Greenstone. En aquest cas, us recomanem que baixeu les pàgines des del vostre navegador. 
}

_textymbyco_ [l=ca] {<p>Podeu basar la col·lecció en: <ul> <li>L'estructura per defecte  <dl><dd>La nova col·lecció pot contenir documents en els formats següents: HTML, només text, correu electrònic "m-box", PDF, RTF, MS Word, PostScript, PowerPoint,  Excel, imatges, CDS/ISIS. </dd></dl> <li>Una col·lecció existent <dl><dd>Els fitxers de la nova col·lecció han de ser exactament del mateix tipus que els que es varen utilitzar per construir la col·lecció existent.</dd></dl> </ul> }

_textbtco_ [l=ca] {Basa la col·lecció en}
_textand_ [l=ca] {Afegeix noves dades}
_textad_ [l=ca] {Afegir dades:}

_texttftysb_ [l=ca] {Els fitxers que especifiqueu a sota s'afegiran a la col·lecció. Comproveu que no torneu a especificar fitxers que ja es troben a la col·lecció, perquè, si no, se'n faran dues còpies. Els fitxers s'identifiquen pel nom complet i el directori on estan guardats; les pàgines web, per la seva adreça web absoluta. }

_textis_ [l=ca] {Fonts de dades:}

_textddd1_ [l=ca] {<p>Si utilitzeu file:// o ftp:// per especificar un fitxer, aquest baixarà. 

<p>Si utilitzeu http:// el resultat dependrà del fet que l'URL us mostri una pàgina web normal al vostre navegador o una llista de fitxers. Si us mostra una pàgina, aquesta baixarà juntament amb  totes les pàgines amb què estigui vinculada mitjançant enllaços, sempre que es trobin en el mateix lloc web, a l'URL inicial.

<p>Si utilitzeu file:// o ftp:// per especificar una carpeta o un directori, o introduïu un 
http:// URL que dugui a una llista de fitxers, tot el que contingui la carpeta i totes les subcarpetes s'inclouran a la col·lecció. 

<p>Pitgeu el botó "més fonts" per obtenir més quadres d'introducció.
}

_textddd2_ [l=ca] {<p>Pitgeu un dels botons verds. Si sou un usuari avançat, potser voldreu ajustar la configuració de la col·lecció.  Una altra possibilitat és anar directament a la fase de construcció. Recordeu que sempre podeu tornar a una fase anterior del procés pitjant el botó groc corresponent. 
}

_textconf1_ [l=ca] {<p>La construcció i la presentació de la vostra col·lecció estan controlades per les especificacions contingudes en un "fitxer de configuració" especial. Els usuaris avançats que ho desitgin, poden modificar els paràmetres de configuració. 

<center><p><b>Si no sou un usuari avançat, aneu al final de la pàgina.</b></center> 

<p>Per modificar els paràmetres de configuració, canvieu les dades que apareixen a sota. Si cometeu un error, pitgeu "Restaurar" per restablir els paràmetres originals de la configuració.
}

_textreset_ [l=ca] {Restaura}

_texttryagain_ [l=ca] {Per favor, <a href="_httppagecollector_" target=_top>torneu a fer arrencar el col·leccionista</a>
i  intenteu-ho de nou. 
}

_textretcoll_ [l=ca] {Torna al col·leccionista}

_textdelperm_ [l=ca] {No s'ha pogut suprimir tota o una part de la col·lecció _cgiargbc1dirnameHtmlsafe_ . Això pot ser perquè:
<ul>
<li> Greenstone no té permís per suprimir el directori _gsdlhome_/collect/_cgiargbc1dirnameHtmlsafe_.<br>
Potser haureu d'eliminar aquest directori manualment per completar la supressió de la col·lecció _cgiargbc1dirnameHtmlsafe_ d'aquest ordinador.</li>
<li>Greenstone no pot executar el programa _gsdlhome_/bin/script/delcol.pl. Comproveu que aquest fitxer es pugui llegir i executar.</li>
</ul>
}

_textdelinv_ [l=ca] {La col·lecció  _cgiargbc1dirnameHtmlsafe_ està protegida o no és vàlida. S'ha cancel·lat la supressió. 
}

_textdelsuc_ [l=ca] {La col·lecció  _cgiargbc1dirnameHtmlsafe_ s'ha suprimit satisfactòriament.}

_textclonefail_ [l=ca] {La col·lecció  _cgiargclonecolHtmlsafe_ no s'ha pogut clonar. Això pot ser perquè: 
<ul>
<li> La col·lecció _cgiargclonecolHtmlsafe_ no existeix
<li> La col·lecció  _cgiargclonecolHtmlsafe_ no té el fitxer de configuració collect.cfg 
<li> Greenstone no té permís per llegir el fitxer de configuració collect.cfg 
</ul>
}

_textcolerr_ [l=ca] {Error en el col·leccionista.}

_texttmpfail_ [l=ca] {El col·leccionista no ha pogut realitzar cap operació de lectura o escriptura en el fitxer o directori temporal. Això pot ser perquè: <ul>
<li> Greenstone no té accés de lectura/escriptura al directori _gsdlhome_/tmp.
   </ul>}

_textmkcolfail_ [l=ca] {El col·leccionista no ha pogut crear l'estructura de directori que requereix la nova col·lecció (mkcol.pl ha fallat). Això pot ser perquè:
<ul>
<li> Greenstone no té permís per escriure al directori _gsdlhome_/tmp.
<li> Hi ha errors en el guió Perl mkcol.pl.
</ul>
}

_textnocontent_ [l=ca] {Error en el col·leccionista: no s'ha donat nom a la nova col·lecció. Proveu de tornar a fer arrencar el col·leccionista des del principi. }

_textrestart_ [l=ca] {Torna a fer arrencar el col·leccionista}

_textreloaderror_ [l=ca] {S'ha produït un error durant la creació de la nova col·lecció. Podria ser que Greenstone s'hagués confós pel vostre ús dels botons "tornar a carregar" o "retrocés" del vostre navegador (procureu no fer servir aquests botons durant la creació d'una col·lecció amb el col·leccionista). És recomanable tornar a fer arrencar el col·leccionista des del principi. }

_textexptsuc_ [l=ca] {La col·lecció  _cgiargbc1dirnameHtmlsafe_ s'ha exportat satisfactòriament al directori _gsdlhome_/tmp/exported\__cgiargbc1dirnameHtmlsafe_. }

_textexptfail_ [l=ca] {<p>No s'ha pogut exportar la col·lecció _cgiargbc1dirnameHtmlsafe_ .  <p>És probable que sigui perquè Greenstone es va instal·lar sense els components necessaris per a la funció "Exportar col·lecció".   <ul>   <li>Si vàreu instal·lar una versió de Greenstone anterior a 2.70w des d'un cd-rom, aquests components no s'hauran instal·lat llevat que els haguéssiu seleccionat durant una instal·lació "personalitzada". Els podeu afegir a la instal·lació tornant a executar el procediment d'instal·lació.   <li>Si vàreu instal·lar Greenstone des d'una distribució a Internet, haureu de baixar i instal·lar un paquet addicional per poder habilitar aquesta funció. Podeu obtenir més informació a <a href="http://www.greenstone.org">http://www.greenstone.org</a> o  <a  href="https://list.scms.waikato.ac.nz/mailman/listinfo/greenstone-users">a la llista de correu</a>.  </ul> }

######################################################################
# depositoraction
package depositor
######################################################################

_textdepositorblurb_ [l=ca] {<p> Especifiqueu la informació de fitxer següent i feu clic a _textintro_ a sota. </p>  }

_textcaec_ [l=ca] {Afegir a una col·lecció existent}
_textbild_ [l=ca] {Diposita l'element}
_textintro_ [l=ca] {Selecciona fitxer}
_textconfirm_ [l=ca] {Confirmació}
_textselect_ [l=ca] {Selecciona col·lecció}
_textmeta_ [l=ca] {Especifica metadades}
_textselectoption_ [l=ca] {selecciona la col·lecció ...}

_texttryagain_ [l=ca] {Reinicieu <a href="_httppagedepositor_" target=_top>el dipositador</a>i torneu a provar-ho. }

_textselectcol_ [l=ca] {Seleccioneu la col·lecció a la qual voleu afegir un nou document}
_textfilename_ [l=ca] {Nom de fitxer}
_textfilesize_ [l=ca] {Mida de fitxer}

_textretcoll_ [l=ca] {Torna al dipositador}

_texttmpfail_ [l=ca] {El dipositador no ha pogut llegir o escriure en un fitxer o directori temporal. Les causes possibles són: <ul> <li> Greenstone no té accés de lectura/escriptura al directori _gsdlhome_/tmp. </ul> }

######################################################################
# 'gsdl' page
package gsdl
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textgreenstone1_ [l=ca] {Greenstone és un conjunt de programes informàtics que serveix per accedir a les col·leccions de biblioteques digitals i per crear noves col·leccions. Ofereix una nova manera d'organitzar la informació i de publicar-la a Internet o en cd-rom. Creat pel Projecte de Biblioteca Digital de Nova Zelanda a la Universitat de Waikato, aquest programari es distribueix en col·laboració amb la UNESCO i l'ONG Human Info. És un programari de codi font obert i es pot obtenir a <i>http://greenstone.org</i> d'acord amb les condicions de la Llicència Pública General GNU. }

_textgreenstone2_ [l=ca] {El lloc web de la Biblioteca Digital de Nova Zelanda (<a
href="http://nzdl.org">http://nzdl.org</a>) conté nombrosos exemples de col·leccions creades amb el programari de Greenstone i que es poden consultar lliurement. Ofereixen exemples de diverses opcions de cerca i navegació i inclouen col·leccions en àrab, xinès, francès, maori i castellà, a més d'anglès. També hi ha algunes col·leccions de música.  }

_textplatformtitle_ [l=ca] {plataforma}
_textgreenstone3_ [l=ca] {Greenstone funciona amb Windows, Unix i Mac OS X. La distribució inclou binaris a punt d'utilitzar per a totes les versions de Windows, Linux i Mac OS X. També conté un codi font complet per al sistema, que es pot compilar amb Microsoft C++ o gcc.  Greenstone funciona amb un programari associat que també es pot obtenir de forma gratuïta: el servidor web Apache i el PERL. La interfície d'usuari utilitza un navegador web com ara Mozilla Firefox o Internet Explorer. }

_textgreenstone4_ [l=ca] {Moltes col·leccions de documents es distribueixen en cd-rom amb el programari de Greenstone. Per exemple, la <i>Biblioteca per al desenvolupament de la humanitat</i> conté 1.230 publicacions que tracten temes tan diversos com la comptabilitat o la depuració d'aigües. S'hi pot accedir des d'ordinadors molt senzills, com els que se solen trobar als països en vies de desenvolupament. La informació es pot trobar mitjançant cerques o consultes per tema, títols, organitzacions, llistes Com o per visualització aleatòria de portades de llibres. }

_textcustomisationtitle_ [l=ca] {personalització}
_textgreenstone5_ [l=ca] {Greenstone està especialment dissenyat perquè es pugui personalitzar i ampliar a voluntat. Greenstone pot tractar nous formats de documents i metadades escrivint "connectors" (<i>plugins</i>), en
llenguatge Perl. També es poden aplicar noves estructures de navegació en les metadades escrivint "classificadors". La interfície d'usuari i la presentació es poden modificar utilitzant les "macros" escrites en un senzill llenguatge de macros. El protocol Corba permet que els agents (per exemple en llenguatge Java) utilitzin totes les funcions disponibles a les col·leccions de documents. Finalment, es pot modificar el codi font en C++ i Perl.
}

_textdocumentationtitle_ [l=ca] {documentació}
_textdocuments_ [l=ca] {Està disponible la documentació completa del programari de Greenstone.}

#_textthreedocs_ {There are three documents that explain the Greenstone system:}
#_textinstall_ {The Greenstone Digital Library Software Installer's Guide}
#_textuser_ {The Greenstone Digital Library Software User's Guide}
#_textdevelop_ {The Greenstone Digital Library Software Developer's Guide}

_textmailinglisttitle_ [l=ca] {llista de correu electrònic}
_textmailinglist_ [l=ca] {Exsteix una llista de correu electrònic pensada especialment per al debat sobre el programari de la biblioteca digital de Greenstone. És recomanable i desitjable que els usuaris actius de Greenstone participin en aquest debat. Us hi podeu inscriure a  <a href="https://list.scms.waikato.ac.nz/mailman/listinfo/greenstone-users">https://list.scms.waikato.ac.nz/mailman/listinfo/greenstone-users</a>.

Per enviar un missatge a la llista, adreceu-lo a <a
href="mailto:greenstone-users@list.scms.waikato.ac.nz"
>greenstone-users@list.scms.waikato.ac.nz</a>.
}

_textbugstitle_ [l=ca] {errors lògics o de programació}
_textreport_ [l=ca] {El nostre desig és que aquest programari funcioni correctament. Per això us preguem que ens informeu de qualsevol problema que hi detecteu a la llista de correu <a href="https://list.scms.waikato.ac.nz/mailman/listinfo/greenstone-users"></a>. }

_textgs3title_ [l=ca] {en fase d'elaboració}
_textgs3_ [l=ca] {Greenstone 3 és una nova versió amb un disseny i una execució completament nous que  conserva tots els avantatges de Greenstone 2 (la versió actual); per exemple,  és plurilingüe, de multiplataforma i altament configurable. Incorpora  totes les característiques del sistema existent i és compatible amb les versions   anteriors: és a dir, pot construir i executar col·leccions existents sense haver de fer cap   modificació. Està escrit en Java i estructurat en forma de xarxa de   mòduls independents que es comuniquen mitjançant XML: per això funciona de   manera distribuïda i es pot estendre a diversos servidors si cal.   Aquest disseny modular augmenta la flexibilitat i la capacitat d'ampliació   de Greenstone. Es poden baixar documentació i versions experimentals de Greenstone 3 des de la <a href="http://www.greenstone.org/greenstone3-home">pàgina d'inici de Greenstone 3</a>.}

_textcreditstitle_ [l=ca] {crèdits}

_textwhoswho_ [l=ca] {El programari de Greenstone és el fruit de la col·laboració de moltes persones. Ian Witten va ser el membre finançador del projecte i Rodger McNab i Stefan Boddie varen ser els principals arquitectes i programadors al començament. També hi han fet aportacions  _contributorlist_. Altres membres del projecte de Biblioteca Digital de Nova Zelanda han aportat valuoses idees i suggeriments al disseny del sistema:  _inspirationlist_. També volem donar les gràcies a tots aquells que han contribuït als paquets amb llicència de GNU que s'inclouen en aquesta dstribució: _gnupackagelist_. }

_textaboutgslong_ [l=ca] {sobre el programari de Greenstone}

######################################################################
# 'users' page
package userslistusers
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textlocu_ [l=ca] {Llista d'usuaris actuals}
_textuser_ [l=ca] {usuari
}
_textas_ [l=ca] {estat del compte}
_textgroups_ [l=ca] {grups}
_textcomment_ [l=ca] {comentari}
_textadduser_ [l=ca] {afegeix un nou usuari}
_textedituser_ [l=ca] {edita}
_textdeleteuser_ [l=ca] {suprimeix}

######################################################################
# 'users' page
package usersedituser
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textedituser_ [l=ca] {Edita informació d'usuari}
_textadduser_ [l=ca] {Afegeix un nou usuari}

_textaboutusername_ [l=ca] {Els noms d'usuari han de ser d'entre 2 i 30 caràcters. Poden contenir caràcters alfanumèrics,  '.' i '_'.}

_textaboutpassword_ [l=ca] {Les contrasenyes han de ser d'entre 3 i 8 caràcters. Poden contenir tots els caràcters normals d'ASCII que es poden imprimir. }

_textoldpass_ [l=ca] {Si aquest camp està en blanc, es conservarà l'antiga contrasenya. }
_textenabled_ [l=ca] {habilitat}
_textdisabled_ [l=ca] {inhabilitat}

_textaboutgroups_ [l=ca] {Els grups són llistes que se separen amb comes, no poseu espais després de les comes. }
_textavailablegroups_ [l=ca] {Els grups predefinits inclouen l'administrador i d'altres que assignen permisos per a la construcció remota de col·leccions mitjançant la Interfície de Bibliotecari o el Dipositador: <ul> <li><b>administrador</b>: Dóna permís per entrar a canviar la configuració de la web i els comptes d'usuaris. <li><b>editor-col·leccions-personals</b>: Dóna permís per crear noves col·leccions personals. <li><b><nom-col·lecció>-editor-col·lecció</b>: Dóna permís per crear i editar la col·lecció "nom-col·lecció", per exemple, editor-col·lecció-informes. <li><b>editor-totes-col·leccions</b>: Dóna permís per crear noves col·leccions personals i globals i editar <b>totes</b> les col·leccions. També dóna permís per utilitzar el Col·leccionador. </ul> }

######################################################################
# 'users' page
package usersdeleteuser
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdeleteuser_ [l=ca] {Suprimeix un usuari}
_textremwarn_ [l=ca] {Segur que voleu suprimir permanentment l'usuari <b>_cgiargumunHtmlsafe_</b>?}

######################################################################
# 'users' page
package userschangepasswd
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textchangepw_ [l=ca] {Canvia la contrasenya}
_textoldpw_ [l=ca] {antiga contrasenya}
_textnewpw_ [l=ca] {nova contrasenya}
_textretype_ [l=ca] {torneu a escriure la nova contrasenya}

######################################################################
# 'users' page
package userschangepasswdok
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textsuccess_ [l=ca] {La vostra contrasenya ha estat canviada. }

######################################################################
# 'users' page
package users
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textinvalidusername_ [l=ca] {El nom d'usuari no és vàlid.}
_textinvalidpassword_ [l=ca] {La contrasenya no és vàlida.}
_textemptypassword_ [l=ca] {Per favor, escriviu una contrasenya inicial per a aquest usuari}
_textuserexists_ [l=ca] {Aquest usuari ja existeix; per favor, escriviu un altre nom d'usuari.}

_textusernameempty_ [l=ca] {Per favor, escriviu el vostre nom d'usuari.}
_textpasswordempty_ [l=ca] {Heu d'introduir la contrasenya antiga.}
_textnewpass1empty_ [l=ca] {Introduïu la nova contrasenya i després torneu-la a escriure.}
_textnewpassmismatch_ [l=ca] {Les dues versions de la nova contrasenya no coincideixen.}
_textnewinvalidpassword_ [l=ca] {Heu escrit una contrasenya no vàlida.}
_textfailed_ [l=ca] {Hi ha un error en el nom d'usuari o la contrasenya.}

######################################################################
# 'status' pages
package status
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textversion_ [l=ca] {Número de versió de Greenstone}
_textframebrowser_ [l=ca] {Per visualitzar això us cal un navegador que accepti marcs ("frames").}
_textusermanage_ [l=ca] {Administració d'usuaris}
_textlistusers_ [l=ca] {llista d'usuaris}
_textaddusers_ [l=ca] {afegeix un nou usuari}
_textchangepasswd_ [l=ca] {canvia la contrasenya}
_textinfo_ [l=ca] {Informació tècnica}
_textgeneral_ [l=ca] {general}
_textarguments_ [l=ca] {arguments}
_textactions_ [l=ca] {accions}
_textbrowsers_ [l=ca] {navegadors}
_textprotocols_ [l=ca] {protocols}
_textconfigfiles_ [l=ca] {Fitxers de configuració}
_textlogs_ [l=ca] {Registres}
_textusagelog_ [l=ca] {resgistre d'ús}
_textinitlog_ [l=ca] {registre d'inicialització}
_texterrorlog_ [l=ca] {registre d'errors}
_textadminhome_ [l=ca] {pàgina principal de l'administració}
_textreturnhome_ [l=ca] {Pàgina principal de Greenstone}
_titlewelcome_ [l=ca] {Administració }
_textmaas_ [l=ca] {Els serveis de manteniment i administració són els següents:}
_textvol_ [l=ca] {visualitza els registres en línia}
_textcmuc_ [l=ca] {crea, manté i actualitza col·leccions}
_textati_ [l=ca] {accedeix a informació tècnica com ara arguments CGI}

_texttsaa_ [l=ca] {Es pot accedir a aquests serveis mitjançant la barra de navegació situada a  l'esquerra de la pàgina.}

_textcolstat_ [l=ca] {Estat de la col·lecció}

_textcwoa_ [l=ca] {Una col·lecció només apareixerà com a "running" (en funcionament) si el fitxer build.cfg existeix, es pot llegir i conté un camp vàlid de "builddate" (data de construcció), és a dir, > 0, i és al directori índex de la col·lecció (és a dir, NO al directori de construcció). }

_textcafi_ [l=ca] {pitgeu <i>abrev.</i> per obtenir informació sobre la col·lecció}
_textcctv_ [l=ca] {pitgeu <i>col·lecció</i> per visualitzar una col·lecció}
_textsubc_ [l=ca] {Aplica canvis}
_texteom_ [l=ca] {Error en obrir main.cfg}
_textftum_ [l=ca] {No s'ha pogut actualitzar main.cfg}
_textmus_ [l=ca] {s'ha actualitzat satisfactòriament el fitxer main.cfg }

######################################################################
# 'bsummary' pages
package bsummary
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textbsummary_ [l=ca] {Resum de construcció de la col·lecció  _collectionname_ }
_textflog_ [l=ca] {Error en el registre de la col·lecció  _collectionname_ }
_textilog_ [l=ca] {Importa el registre de la col·lecció "_collectionname_" }

############################################################################
#
# This stuff is only used by the usability (SEND FEEDBACK) stuff
#
############################################################################
package Global

# old cusab button
_linktextusab_ [l=ca] {ENVIA COMENTARI}

_greenstoneusabilitytext_ [l=ca] {Capacitat d'ús de Greenstone}

_textwhy_ [l=ca] {<p>Enviar aquest informe és una manera d'indicar que la pàgina que miràveu us ha semblat difícil d'utilitzar o frustrant.}
_textextraforform_ [l=ca] {No cal que empleneu el formulari -- qualsevol informació serà d'utilitat.}
_textprivacybasic_ [l=ca] {<p>L'informe només contindrà informació sobre la pàgina web de Greenstone que estàveu visualitzant i sobre la tecnologia que empràveu per visualitzar-la (a més de qualsevol informació opcional que doneu). }
_textstillsend_ [l=ca] {Encara voleu enviar aquest informe?}

_texterror_ [l=ca] {error}
_textyes_ [l=ca] {Sí}
_textno_ [l=ca] {No}
_textclosewindow_ [l=ca] {Tanca la finestra}
_textabout_ [l=ca] {Sobre}
_textprivacy_ [l=ca] {Privadesa}
_textsend_ [l=ca] {Envia}
_textdontsend_ [l=ca] {No enviïs}
_textoptionally_ [l=ca] {Opcionalment}

_textunderdev_ [l=ca] {La vista preliminar dels detalls estarà disponible a la versió final.}

_textviewdetails_ [l=ca] {Mostra els detalls de l'informe}
_textmoredetails_ [l=ca] {Més detalls}
_texttrackreport_ [l=ca] {Segueix el recorregut d'aquest informe}
_textcharacterise_ [l=ca] {Quina mena de problema és}
_textseverity_ [l=ca] {Com és de greu el problema?}

_textbadrender_ [l=ca] {La pàgina es veu rara}
_textcontenterror_ [l=ca] {Error de contingut}
_textstrangebehaviour_ [l=ca] {Comportament estrany}
_textunexpected_ [l=ca] {S'ha produït un fet inesperat}
_textfunctionality_ [l=ca] {Difícil d'utilitzar}
_textother_ [l=ca] {Altre}

_textcritical_ [l=ca] {Crític}
_textmajor_ [l=ca] {Greu}
_textmedium_ [l=ca] {Mitjà}
_textminor_ [l=ca] {Lleu}
_texttrivial_ [l=ca] {Trivial}

_textwhatdoing_ [l=ca] {Què intentàveu fer?}
_textwhatexpected_ [l=ca] {Què pensàveu que passaria?}
_textwhathappened_ [l=ca] {Què ha passat realment?}

_cannotfindcgierror_ [l=ca] {<h2>Disculpeu!</h2>No\\ s'han trobat els programes del servidor per al botó "_linktextusab_".}

_textusabbanner_ [l=ca] {el rètol d'estil koru de Greenstone }

######################################################################
# GTI text strings
package gti
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textgtierror_ [l=ca] {S'ha produït un error}

_textgtihome_ [l=ca] {Aquestes pàgines us ajudaran a millorar el suport plurilingüe de Greenstone. Amb elles, podreu  <ul>   <li>traduir parts de Greenstone a un nou idioma   <li>actualitzar una interfície d'idioma ja existent quan es modifiqui la interfície en anglès (p.ex., per a noves funcions de Greenstone)   <li>corregir errors a les traduccions existents </ul>  Se us presentarà un seguit de pàgines web, que contindran cadascuna   una frase per traduir. Aneu traduint la interfície al vostre idioma frase per frase.  Moltes frases contenen ordres de format HTML: no intenteu  traduir-les, conserveu-les intactes a la versió traduïda. Les paraules entre guions baixos (com _aquesta_) tampoc no  s'han de traduir (són els noms de les "macros" de Greenstone). <p> Si esteu actualitzant una interfície d'idioma ja existent no se us presentaran  frases que ja estiguin traduïdes. De vegades, hi ha una traducció  però el text en anglès ha canviat des que es va traduir. En aquest cas, es presentarà una traducció  actual que haureu de comprovar i, si cal, actualitzar. <p> Per corregir una traducció que ja s'hagi actualitzat, utilitzeu la funció de "Corregir traducció existent" que ve amb cada part de Greenstone. <p> Cada pàgina acaba amb un botó "_textgtisubmit_". Quan el pitgeu, els canvis s'incorporen  immediatament a una instal·lació separada de Greenstone a nzdl.org. A cada  pàgina apareix un botó per accedir a aquest lloc web.  }

_textgtiselecttlc_ [l=ca] {Seleccioneu el vostre idioma}

#for status page
_textgtiviewstatus_ [l=ca] {Feu clic per visualitzar l'estat actual de traducció de tots els idiomes}
_textgtiviewstatusbutton_ [l=ca] {VISUALITZA ESTAT}
_textgtistatustable_ [l=ca] {Llista d'estat actual de traducció de tots els idiomes}
_textgtilanguage_ [l=ca] {Idioma}
_textgtitotalnumberoftranslations_ [l=ca] {Nombre total de traduccions}

_textgtiselecttfk_ [l=ca] {Seleccioneu un fitxer per treballar-hi}

_textgticoredm_ [l=ca] {Interfície de Greenstone 2 (central) }
_textgtiauxdm_ [l=ca] {Interfície de Greenstone 2 (auxiliar) }
_textgtiglidict_ [l=ca] {Diccionari de la IBG}
_textgtiglihelp_ [l=ca] {Ajuda de la IBG}
_textgtiperlmodules_ [l=ca] {Mòduls de Perl}
_textgtitutorials_ [l=ca] {Exercicis tutorials}
_textgtigreenorg_ [l=ca] {Greenstone.org}
_textgtigs3interface_ [l=ca] {Inertíficie de Greenstone 3}
_textgtigsinstaller_ [l=ca] {Instal·lador de Greenstone}
_textgtigs3colcfg_ [l=ca] {Cadena de caràcters collection-config de la demo de GS3}

#for greenstone manuals
_textgtidevmanual_ [l=ca] {Manual del programador de Greenstone}
_textgtiinstallmanual_ [l=ca] {Manual de l'instal·lador de Greenstone}
_textgtipapermanual_ [l=ca] {Manual de Greenstone per traslladar de paper a col·lecció}
_textgtiusermanual_ [l=ca] {Manual de l'usuari de Greenstone}

_textgtienter_ [l=ca] {INTRODUEIX}

_textgticorrectexistingtranslations_ [l=ca] {Corregir traduccions existents}
_textgtidownloadtargetfile_ [l=ca] {Baixa fitxer}
_textgtiviewtargetfileinaction_ [l=ca] {Visualitza aquest fitxer en acció}
_textgtitranslatefileoffline_ [l=ca] {Traduir aquest fitxer sense connexió a internet}

_textgtinumchunksmatchingquery_ [l=ca] {Nombre de fragments de text que coincideixen amb la consulta }

_textgtinumchunkstranslated_ [l=ca] {traduccions fetes}
_textgtinumchunksrequiringupdating_ [l=ca] {D'aquestes, _1_ necessiten actualització}
_textgtinumchunksrequiringtranslation_ [l=ca] {traduccions que falten}

#for status page
_textgtinumchunkstranslated2_ [l=ca] {nombre de traduccions fetes}
_textgtinumchunksrequiringupdating2_ [l=ca] {nombre de traduccions que necessiten actualització }
_textgtinumchunksrequiringtranslation2_ [l=ca] {nombre de traduccions que falten}

_textgtienterquery_ [l=ca] {Introduïu una paraula o una frase del fragment de text que vulgueu corregir}
_textgtifind_ [l=ca] {CERCA}

_textgtitranslatingchunk_ [l=ca] {Està traduint el fragment de text <i>_1_</i>}
_textgtiupdatingchunk_ [l=ca] {Està actualitzant el fragment de text <i>_1_</i>}
_textgtisubmit_ [l=ca] {ENVIA}

_textgtilastupdated_ [l=ca] {Darrera actualització }

_textgtitranslationfilecomplete_ [l=ca] {Gràcies per actualitzar aquest fitxer, ara està complet!<p>Podeu baixar una còpia del fitxer amb l'enllaç del damunt, i també s'inclourà en futures edicions de Greenstone. }

_textgtiofflinetranslation_ [l=ca] {Podeu traduir aquesta part de Greenstone sense connexió a Internet fent servir un full de càlcul d'Excel:  <ol> <li>Baixeu <a href="_gwcgi_?a=gti&p=excel&tct=work&e=_compressedoptions_">aquest fitxer</a> per a tota la feina restant, o bé <a href="_gwcgi_?a=gti&p=excel&tct=all&e=_compressedoptions_">aquest fitxer</a> per a totes les cadenes d'aquest mòdul. <li>Obriu el fitxer que heu baixat amb Microsoft Excel (cal tenir Office 2003/XP o versions més recents) i deseu-lo com a llibre de treball de Microsoft Excel (format .xls). <li>Introduïu les traduccions a les caselles corresponents. <li>Quan hàgiu acabat de traduir totes les cadenes, envieu el fitxer .xls per correu electrònic a <a href="mailto:_gtiadministratoremail_">_gtiadministratoremail_</a>. </ol> }

############
# gli page
############
package gli

_textglilong_ [l=ca] {la interficie del bibliotecari de Greenstone}
_textglihelp_ [l=ca] {La Interfície del Bibliotecari de Greenstone (IBG, o GLI en anglès) us facilita l'accés a les funcions de Greenstone mitjançant una interfície fàcil d'utilitzar en la qual només cal "apuntar i pitjar". Això us permet recopilar grups de documents, importar o assignar metadades i incorporar-les a una col·lecció de Greenstone.<p> <p>Recordeu que la IBG s'executa juntament amb Greenstone i que presuposa que està instal·lada en un subdirectori de la vostra instal·lació de Greenstone. Aquest serà el cas si heu baixat una de les distribucions de Greenstone d'Internet, o si l'heu instal·lada a partir d'un cd-rom de Greenstone.     <h4>Executar la IBG des de Windows</h4>   Si treballeu amb Windows, feu arrencar la interfície del bibliotecari seleccionant <i>Biblioteca Digital Greenstone</i> a la secció <i>Programes</i> del menú <i>Inici</i> i triant <i>Interfície del bibliotecari</i>.     <h4>Excutar la IBG des d'Unix</h4>   Per executar la IBG des d'Unix, canvieu al directori <i>ibg</i> de la vostra instal·lació de Greenstone i llavors executeu l'script <i>gli.sh</i>.    <h4>Executar la IBG des de Mac OS X</h4>  En el cercador, aneu a <i>Aplicacions</i> i d'allà a <i>Greenstone</i> (si heu instal·lat Greenstone a la ubicació per defecte), i llavors feu arrencar l'aplicació <i>IBG</i>. }
