/**************************************************************************
 *
 * invf.h -- Data structures for inverted files
 * Copyright (C) 1994  Neil Sharman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: invf.h 25147 2012-02-28 00:59:00Z kjdon $
 *
 **************************************************************************/



#ifndef H_INVF
#define H_INVF

/* NOTE: This does not include the magic number */
struct invf_dict_header
  {
    mg_u_long lookback;
    mg_u_long dict_size;
    mg_u_long total_bytes;
    mg_u_long index_string_bytes;
    double input_bytes; /* [RJM 07/97: 4G limit] */
    mg_u_long num_of_docs;
    mg_u_long static_num_of_docs;
    mg_u_long num_of_words;
    mg_u_long stemmer_num;
    mg_u_long stem_method;
  };

struct stem_dict_header
  {
    mg_u_long lookback;
    mg_u_long block_size;
    mg_u_long num_blocks;
    mg_u_long blocks_start;
    mg_u_long index_chars;
    mg_u_long num_of_docs;
    mg_u_long static_num_of_docs;
    mg_u_long num_of_words;
    mg_u_long stemmer_num;
    mg_u_long stem_method;
    mg_u_long indexed;       /* [RPAP - Jan 97: Stem Index Change] */
  };

struct invf_file_header
  {
    mg_u_long no_of_words;
    mg_u_long no_of_ptrs;
    mg_u_long skip_mode;
    mg_u_long params[16];
    mg_u_long InvfLevel;
  };

/* [RPAP - Jan 97: Stem Index Change] */
struct stem_idx_header
  {
    mg_u_long lookback;
    mg_u_long block_size;
    mg_u_long num_blocks;
    mg_u_long blocks_start;
    mg_u_long index_chars;
    mg_u_long num_of_words;
  };

#endif
