package org.greenstone.LuceneWrapper4;

import org.apache.lucene.util.Version;


/**
 * Declares the version of Lucene that Greenstone is using. 
 * http://stackoverflow.com/questions/320588/interfaces-with-static-fields-in-java-for-sharing-constants
 * "Instead of using an interface, use a final class with a private constructor. (Making it impossible to 
 * instantiate or subclass the class, sending a strong message that it doesn't contain non-static 
 * functionality/data.)"
 * "Doing a static import doesn't add those members to the class and publish them as part of the class" whereas
 * inheritance would. Static imports allow "avoiding having to use the class name, i.e. ConstClass.SOME_CONST"
 * and you can directly use SOME_CONST in the classes that statically import this class. 
 * E.g. import static org.greenstone.LuceneWrapper.GSLuceneConstants.*;
 * 
 * http://docs.oracle.com/javase/1.5.0/docs/guide/language/static-import.html
 * explains when and how to use static imports.
 * http://stackoverflow.com/questions/162187/what-does-the-static-modifier-after-import-mean
 * and http://www.java2novice.com/java-fundamentals/static-import/
 * clarifies usage.
 */
public final class GSLuceneConstants {

    /** Having a private constructor prevents instantiation and this being a final class prevents subclassing,
     *  indicating that this is a class with purely static constants (and/or methods). 
     */
    private GSLuceneConstants() {}

    // http://lucene.apache.org/core/3_6_0/api/core/org/apache/lucene/util/Version.html
    public static final Version MATCH_VERSION = Version.LUCENE_47; // Version.LUCENE_24;

    // If we want to programmatically set or change the version, we should do it in this interface.

    // Options to initialise it non-statically are: 
    // 1. Read the version in from a property file. 
    // Like Solr seems to do, see http://lucene.472066.n3.nabble.com/Global-User-defined-properties-solr-xml-from-Solr-4-4-to-Solr-4-5-td4097740.html

    // 2. We could set it as an env var. However, it will be hard to update all our setup scripts to pass 
    // this new env-var around to every part of greenstone and make code use it where it needs to be used.
    // The Version class is an Enum. If we set Version as an env var, need to convert that env var string 
    // into the enum. See http://stackoverflow.com/questions/604424/java-convert-string-to-enum
    // GS_LUCENE_VERSION = Version.valueOf(System.getenv("GS_LUCENE_VERSION"));    

}