/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.greenstone.server.BaseServer;
import org.greenstone.server.Server3Control;
import org.greenstone.server.Server3Property;
import org.greenstone.util.GlobalProperties;
import org.greenstone.util.ProtocolPortProperties;
import org.greenstone.util.RunAnt;

public class Server3
extends BaseServer {
    String opt_ant_properties = null;
    ProtocolPortProperties protocolPortProps = null;

    public Server3(String gsdl3_src_home, String lang) {
        super(gsdl3_src_home, lang, gsdl3_src_home + File.separatorChar + "build.properties", "web" + File.separator + "logs");
        try {
            this.protocolPortProps = new ProtocolPortProperties(config_properties);
        }
        catch (Exception e) {
            String errorMsg = "@@@ Error with ports/protocol in " + config_properties_file + ": " + e.getMessage();
            logger_.error((Object)errorMsg, (Throwable)e);
            System.err.println(errorMsg);
            System.exit(-1);
        }
        Property = new Server3Property(this.protocolPortProps.getDefaultPortPropertyName());
        String frame_title = dictionary.get("ServerControl.Frame_Title");
        this.server_control_ = new Server3Control(this, frame_title);
        START_CMD = "start";
        RESTART_CMD = "restart";
        CONFIGURE_CMD = "configure";
        STOP_CMD = "force-stop-tomcat force-stop-derby";
        String is_read_only = System.getProperty("gsdl3home.isreadonly", "false");
        if (is_read_only.equals("true")) {
            String default_gsdl3_home = gsdl3_src_home + File.separatorChar + "web";
            String gsdl3_writablehome = System.getProperty("gsdl3.writablehome", default_gsdl3_home);
            this.opt_ant_properties = "-Dgsdl3home.isreadonly=true -Dgsdl3.writablehome=" + gsdl3_writablehome;
        }
        this.autoStart();
    }

    @Override
    protected int runTarget(String cmd) {
        RunAnt runAnt = new RunAnt(this.opt_ant_properties);
        runAnt.setTargetCmd(cmd);
        runAnt.run();
        return runAnt.getTargetState();
    }

    @Override
    public String getBrowserURL() {
        return GlobalProperties.getFullGSDL3WebAddress() + config_properties.getProperty(BaseServer.Property.DEFAULT_SERVLET);
    }

    public String fallbackGSDL3Home() {
        return this.gsdl_home + File.separator + "web";
    }

    @Override
    public void reload() {
        String gsdl3_writablehome = System.getProperty("gsdl3.writablehome", this.fallbackGSDL3Home());
        GlobalProperties.loadGlobalProperties(gsdl3_writablehome);
    }

    public static void main(String[] args) {
        String gsdl3_src_home;
        File gsdl3_src_dir;
        if (args.length < 1 || args.length > 2) {
            System.err.println("Usage: java org.greenstone.server.Server3 <gsdl3-src-home> [lang]");
            System.exit(1);
        }
        if (!(gsdl3_src_dir = new File(gsdl3_src_home = args[0])).isDirectory()) {
            System.err.println("src directory does not exist!");
            System.exit(1);
        }
        String lang = args.length == 2 ? args[1] : "en";
        new Server3(gsdl3_src_home, lang);
    }

    @Override
    protected void initLogger() {
        String gsdl3_home = GlobalProperties.getGSDL3Home();
        if (gsdl3_home == null) {
            gsdl3_home = this.fallbackGSDL3Home();
        }
        String gsdl3_writablehome = System.getProperty("gsdl3.writablehome", gsdl3_home);
        String propsFolder = gsdl3_writablehome + File.separator + "WEB-INF" + File.separator + "classes" + File.separator;
        File propsFile = new File(propsFolder + "log4j.properties");
        try {
            FileInputStream infile = new FileInputStream(new File(this.gsdl_home + File.separator + "resources" + File.separator + "web" + File.separator + "log4j.properties.svn"));
            if (infile != null) {
                Properties logProps = new Properties();
                logProps.load(infile);
                infile.close();
                logProps.setProperty("gsdl3.home", gsdl3_home);
                logProps.setProperty("gsdl3.writablehome", gsdl3_writablehome);
                FileOutputStream outfile = new FileOutputStream(propsFile);
                if (outfile != null) {
                    logProps.store(outfile, "Customised log4j.properties file");
                    outfile.close();
                } else {
                    System.err.println("Could not store properties file " + propsFile + " for Server3.");
                }
            }
        }
        catch (Exception e) {
            System.err.println("Exception occurred when custom-configuring the logger for Server3.\n" + e);
            e.printStackTrace();
        }
        if (propsFile.exists()) {
            PropertyConfigurator.configure((String)propsFile.getAbsolutePath());
        } else {
            System.err.println("Could not create properties file " + propsFile + " for Server3.");
        }
    }
}

