/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.server;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;
import org.greenstone.server.BaseServer;
import org.greenstone.util.ScriptReadWrite;

public abstract class BaseServerSettings
extends JDialog
implements ActionListener {
    static Logger logger = Logger.getLogger((String)BaseServerSettings.class.getName());
    static final int DEFPORT = 8080;
    static final Color bg_color = Color.white;
    protected JCheckBox autoEnter;
    protected JCheckBox keepPortToggle;
    protected JCheckBox allowConnections;
    protected JSpinner portNumber_spinner = null;
    protected JTextField program_path_field = null;
    protected JButton browse_button = null;
    protected JRadioButton default_browser_button = null;
    protected JRadioButton other_browser_button = null;
    protected Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    protected int portNum = 8080;
    protected boolean autoStart = false;
    protected boolean keepPort = false;
    protected String browserPath = "";
    protected boolean useDefaultBrowser = true;
    protected boolean externalaccess = false;
    protected JDialog self = this;
    protected BaseServer server;

    public BaseServerSettings(BaseServer server) {
        super(server.getServerControl(), "", true);
        this.server = server;
        try {
            this.portNum = Integer.parseInt(BaseServer.config_properties.getProperty(BaseServer.Property.WEB_PORT));
        }
        catch (Exception e) {
            logger.error((Object)e);
            System.err.println("Unable to proceed. Port number property " + BaseServer.Property.WEB_PORT + " doesn't exist\nor contains a non-numeric value");
            System.exit(-1);
        }
        this.browserPath = BaseServer.config_properties.getProperty(BaseServer.Property.BROWSER_PATH);
        if (this.browserPath == null || this.browserPath.equals("")) {
            this.useDefaultBrowser = true;
            this.browserPath = "";
        } else {
            this.useDefaultBrowser = false;
        }
        String auto_start_str = BaseServer.config_properties.getProperty(BaseServer.Property.AUTOSTART, "1").trim();
        this.autoStart = auto_start_str.equals("true") || auto_start_str.equals("1");
        String keep_port_str = BaseServer.config_properties.getProperty(BaseServer.Property.KEEPPORT, "false").trim();
        this.keepPort = keep_port_str.equals("true") || keep_port_str.equals("1");
        this.setTitle(BaseServer.dictionary.get("ServerSettings.Title"));
        this.setDefaultCloseOperation(0);
        JLabel port_label = new JLabel(BaseServer.dictionary.get(BaseServer.Property.SERVER_SETTINGS + ".Port"));
        this.portNumber_spinner = new JSpinner(new SpinnerNumberModel(this.portNum, 1, 65535, 1));
        this.portNumber_spinner.setEditor(new JSpinner.NumberEditor(this.portNumber_spinner, "#####"));
        this.autoEnter = new JCheckBox(BaseServer.dictionary.get("ServerSettings.Auto_Start"));
        this.keepPortToggle = new JCheckBox(BaseServer.dictionary.get("ServerSettings.Keep_Port"));
        if (this.autoStart) {
            this.autoEnter.setSelected(true);
        } else {
            this.autoEnter.setSelected(false);
        }
        this.autoEnter.setBackground(bg_color);
        if (this.keepPort) {
            this.keepPortToggle.setSelected(true);
        } else {
            this.keepPortToggle.setSelected(false);
        }
        this.keepPortToggle.setBackground(bg_color);
        boolean allowCons = false;
        String externalAccessStr = BaseServer.config_properties.getProperty(BaseServer.Property.ALLOW_EXTERNAL_ACCESS, "1").trim();
        this.allowConnections = new JCheckBox(BaseServer.dictionary.get("ServerSettings.ExternalAccess"), allowCons);
        if (externalAccessStr.equals("1") || externalAccessStr.equals("true")) {
            this.externalaccess = true;
            allowCons = true;
            this.allowConnections.setSelected(true);
        } else {
            this.allowConnections.setSelected(false);
        }
        this.allowConnections.setBackground(bg_color);
        JButton save_button = new JButton(BaseServer.dictionary.get("ServerSettings.OK"));
        save_button.addActionListener(new SaveActionListener());
        JButton exit_button = new JButton(BaseServer.dictionary.get("ServerSettings.Cancel"));
        exit_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BaseServerSettings.this.self.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                BaseServerSettings.this.self.dispose();
            }
        });
        JPanel port_panel = new JPanel();
        port_panel.setLayout(new FlowLayout(0));
        port_panel.add(port_label);
        port_panel.add(this.portNumber_spinner);
        port_panel.setBackground(bg_color);
        JPanel top_panel = new JPanel(new GridLayout(4, 1));
        top_panel.add(port_panel);
        top_panel.add(this.keepPortToggle);
        top_panel.add(this.autoEnter);
        top_panel.add(this.allowConnections);
        JPanel comb_panel = this.createServletPanel();
        comb_panel.setBackground(bg_color);
        JPanel mid_panel = new JPanel();
        mid_panel.setLayout(new BorderLayout());
        mid_panel.add((Component)top_panel, "North");
        mid_panel.add((Component)comb_panel, "Center");
        mid_panel.setBackground(bg_color);
        mid_panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JPanel browser_panel = new JPanel();
        browser_panel.setLayout(new GridLayout(4, 1));
        this.default_browser_button = new JRadioButton(BaseServer.dictionary.get("ServerSettings.DefaultBrowser"));
        this.other_browser_button = new JRadioButton(BaseServer.dictionary.get("ServerSettings.OtherBrowser"));
        this.default_browser_button.addActionListener(this);
        this.other_browser_button.addActionListener(this);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.default_browser_button);
        bg.add(this.other_browser_button);
        this.default_browser_button.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 0));
        this.default_browser_button.setBackground(bg_color);
        this.other_browser_button.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 0));
        this.other_browser_button.setBackground(bg_color);
        JPanel browse_program_panel = new JPanel();
        browse_program_panel.setLayout(new BorderLayout());
        this.program_path_field = new JTextField(this.browserPath);
        this.browse_button = new JButton(BaseServer.dictionary.get("ServerSettings.Browse"));
        browse_program_panel.add((Component)this.program_path_field, "Center");
        browse_program_panel.add((Component)this.browse_button, "East");
        browse_program_panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 0));
        browse_program_panel.setBackground(bg_color);
        browser_panel.add(new JLabel(BaseServer.dictionary.get("ServerSettings.ChooseBrowser")));
        browser_panel.add(this.default_browser_button);
        browser_panel.add(this.other_browser_button);
        browser_panel.add(browse_program_panel);
        browser_panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        browser_panel.setBackground(bg_color);
        if (this.useDefaultBrowser) {
            this.default_browser_button.setSelected(true);
            this.program_path_field.setEnabled(false);
            this.browse_button.setEnabled(false);
        } else {
            this.other_browser_button.setSelected(true);
        }
        this.browse_button.addActionListener(this);
        JPanel down_panel = new JPanel();
        down_panel.setLayout(new FlowLayout(1, 5, 5));
        down_panel.add(save_button);
        down_panel.add(exit_button);
        down_panel.setBackground(bg_color);
        down_panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.getContentPane().add((Component)mid_panel, "North");
        this.getContentPane().add((Component)browser_panel, "Center");
        this.getContentPane().add((Component)down_panel, "South");
        this.getContentPane().setBackground(bg_color);
        this.pack();
        this.setLocation((this.screen.width - this.getWidth()) / 2, (this.screen.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    protected boolean[] onSave() {
        boolean[] returnValues = new boolean[]{false, false};
        return returnValues;
    }

    protected void save(ScriptReadWrite scriptReadWrite, ArrayList<String> newFileLines) {
    }

    protected abstract JPanel createServletPanel();

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.browse_button) {
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showOpenDialog(this.self);
            if (returnVal == 0) {
                File program_path = chooser.getSelectedFile();
                this.program_path_field.setText(program_path.getPath());
            }
        } else if (this.default_browser_button.isSelected()) {
            this.program_path_field.setEnabled(false);
            this.browse_button.setEnabled(false);
        } else {
            this.program_path_field.setEnabled(true);
            this.browse_button.setEnabled(true);
        }
    }

    private class SaveActionListener
    implements ActionListener {
        private SaveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            boolean has_changed = false;
            boolean require_restart = false;
            boolean port_has_changed = false;
            if (BaseServerSettings.this.portNum != (Integer)BaseServerSettings.this.portNumber_spinner.getValue()) {
                port_has_changed = true;
                has_changed = true;
                require_restart = true;
                BaseServerSettings.this.server.reconfigRequired();
                BaseServerSettings.this.portNum = (Integer)BaseServerSettings.this.portNumber_spinner.getValue();
                logger.info((Object)("port changed, new port is " + BaseServerSettings.this.portNumber_spinner.getValue()));
            }
            if (BaseServerSettings.this.autoStart != BaseServerSettings.this.autoEnter.isSelected()) {
                has_changed = true;
            }
            if (BaseServerSettings.this.keepPort != BaseServerSettings.this.keepPortToggle.isSelected()) {
                has_changed = true;
            }
            boolean oldExternalAccess = BaseServerSettings.this.externalaccess;
            boolean bl = BaseServerSettings.this.externalaccess = BaseServerSettings.this.allowConnections.isSelected();
            if (oldExternalAccess != BaseServerSettings.this.externalaccess) {
                has_changed = true;
                require_restart = true;
                BaseServerSettings.this.server.reconfigRequired();
            }
            boolean[] returnValues = BaseServerSettings.this.onSave();
            has_changed = has_changed || returnValues[0];
            boolean bl2 = require_restart = require_restart || returnValues[1];
            if (BaseServerSettings.this.useDefaultBrowser && BaseServerSettings.this.other_browser_button.isSelected()) {
                BaseServerSettings.this.browserPath = BaseServerSettings.this.program_path_field.getText();
                has_changed = true;
            }
            if (!BaseServerSettings.this.useDefaultBrowser && !BaseServerSettings.this.browserPath.equals(BaseServerSettings.this.program_path_field.getText())) {
                BaseServerSettings.this.browserPath = BaseServerSettings.this.program_path_field.getText();
                has_changed = true;
            }
            if (BaseServerSettings.this.default_browser_button.isSelected() && !BaseServerSettings.this.useDefaultBrowser) {
                BaseServerSettings.this.browserPath = "";
                has_changed = true;
            }
            if (has_changed) {
                ArrayList<String> oldFileLines = null;
                ArrayList<String> newFileLines = null;
                ScriptReadWrite scriptReadWrite = new ScriptReadWrite();
                oldFileLines = scriptReadWrite.readInFile(BaseServer.config_properties_file);
                newFileLines = scriptReadWrite.queryReplace(oldFileLines, BaseServer.Property.WEB_PORT, BaseServerSettings.this.portNum + "");
                BaseServerSettings.this.save(scriptReadWrite, newFileLines);
                String osName = System.getProperty("os.name");
                if (osName.startsWith("Windows")) {
                    BaseServerSettings.this.browserPath = BaseServerSettings.this.browserPath.replaceAll("\\\\", "/");
                }
                newFileLines = scriptReadWrite.replaceOrAddLine(newFileLines, BaseServer.Property.BROWSER_PATH, BaseServerSettings.this.browserPath, true);
                scriptReadWrite.writeOutFile(BaseServer.config_properties_file, newFileLines);
                boolean success = BaseServerSettings.this.server.reloadConfigProperties(port_has_changed);
                BaseServerSettings.this.server.reload();
                if (success && require_restart) {
                    BaseServer cfr_ignored_0 = BaseServerSettings.this.server;
                    JOptionPane.showMessageDialog(null, BaseServer.dictionary.get("ServerSettings.SettingChanged"), "Info", 1);
                    if (BaseServerSettings.this.autoStart) {
                        BaseServerSettings.this.server.autoStart();
                        BaseServerSettings.this.server.getServerControl().updateControl();
                    }
                }
            }
            BaseServerSettings.this.self.dispose();
        }
    }
}

