/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class StopFilter
extends TokenFilter {
    private static boolean ENABLE_POSITION_INCREMENTS_DEFAULT = false;
    private final CharArraySet stopWords;
    private boolean enablePositionIncrements = ENABLE_POSITION_INCREMENTS_DEFAULT;

    public StopFilter(TokenStream input, String[] stopWords) {
        this(input, stopWords, false);
    }

    public StopFilter(TokenStream in, String[] stopWords, boolean ignoreCase) {
        super(in);
        this.stopWords = (CharArraySet)StopFilter.makeStopSet(stopWords, ignoreCase);
    }

    public StopFilter(TokenStream input, Set stopWords, boolean ignoreCase) {
        super(input);
        if (stopWords instanceof CharArraySet) {
            this.stopWords = (CharArraySet)stopWords;
        } else {
            this.stopWords = new CharArraySet(stopWords.size(), ignoreCase);
            this.stopWords.addAll(stopWords);
        }
    }

    public StopFilter(TokenStream in, Set stopWords) {
        this(in, stopWords, false);
    }

    public static final Set makeStopSet(String[] stopWords) {
        return StopFilter.makeStopSet(stopWords, false);
    }

    public static final Set makeStopSet(String[] stopWords, boolean ignoreCase) {
        CharArraySet stopSet = new CharArraySet(stopWords.length, ignoreCase);
        stopSet.addAll(Arrays.asList(stopWords));
        return stopSet;
    }

    public final Token next(Token result) throws IOException {
        int skippedPositions = 0;
        while ((result = this.input.next(result)) != null) {
            if (!this.stopWords.contains(result.termBuffer(), 0, result.termLength)) {
                if (this.enablePositionIncrements) {
                    result.setPositionIncrement(result.getPositionIncrement() + skippedPositions);
                }
                return result;
            }
            skippedPositions += result.getPositionIncrement();
        }
        return null;
    }

    public static boolean getEnablePositionIncrementsDefault() {
        return ENABLE_POSITION_INCREMENTS_DEFAULT;
    }

    public static void setEnablePositionIncrementsDefault(boolean defaultValue) {
        ENABLE_POSITION_INCREMENTS_DEFAULT = defaultValue;
    }

    public boolean getEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public void setEnablePositionIncrements(boolean enable) {
        this.enablePositionIncrements = enable;
    }
}

