/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.options;

import com.sun.jimi.core.options.BasicFormatOptionSet;
import com.sun.jimi.core.options.BooleanOption;
import com.sun.jimi.core.options.FormatOption;
import com.sun.jimi.core.options.IntOption;
import com.sun.jimi.core.options.OptionException;

public class GIFOptions
extends BasicFormatOptionSet {
    public static final int NO_TRANSPARENCY = -1;
    public static final int LOOP_FOREVER = 0;
    protected IntOption transparentIndex = new IntOption("Transparent index", "The palette index of the image which should be treated as transparent, or -1 for no transparency.", -1);
    protected BooleanOption interlace = new BooleanOption("Interlace", "Whether the image is interlaced.", false);
    protected IntOption frameDelay = new IntOption("Frame delay", "For Animated GIFs, the number of hundredths of seconds to display a frame for.", 100, 0, 65535);
    protected BooleanOption localPalette = new BooleanOption("Local palette", "For Animated GIFs, whether each frame has its own palette.", true);
    protected IntOption numberOfLoops = new IntOption("Number of loops", "For Animated GIFs, how many times to loop through the animation, or -1 to loop forever.", 0);

    public void setTransparentIndex(int n) throws OptionException {
        this.transparentIndex.setIntValue(n);
    }

    public int getTransparentIndex() {
        return this.transparentIndex.getIntValue();
    }

    public void setInterlaced(boolean bl) throws OptionException {
        this.interlace.setBooleanValue(bl);
    }

    public boolean isInterlaced() {
        return this.interlace.getBooleanValue();
    }

    public void setFrameDelay(int n) throws OptionException {
        this.frameDelay.setIntValue(n);
    }

    public int getFrameDelay() {
        return this.frameDelay.getIntValue();
    }

    public void setUseLocalPalettes(boolean bl) {
        this.localPalette.setBooleanValue(bl);
    }

    public boolean isUsingLocalPalettes() {
        return this.localPalette.getBooleanValue();
    }

    public void setNumberOfLoops(int n) throws OptionException {
        this.numberOfLoops.setIntValue(n);
    }

    public int getNumberOfLoops() {
        return this.numberOfLoops.getIntValue();
    }

    public String toString() {
        return "[transparentIndex=" + this.transparentIndex.getIntValue() + ", interlace=" + this.interlace.getBooleanValue() + ", frameDelay=" + this.frameDelay.getIntValue() + ", localPalette=" + this.localPalette.getBooleanValue() + ", numberOfLoops=" + this.numberOfLoops.getIntValue() + "]";
    }

    public GIFOptions() {
        this.initWithOptions(new FormatOption[]{this.transparentIndex, this.interlace, this.frameDelay, this.localPalette, this.numberOfLoops});
    }
}

