/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiReader;
import com.sun.jimi.core.util.JimiUtil;
import java.util.Enumeration;

class ImageSeriesEnumerator
implements Enumeration {
    protected static final int IMAGE = 0;
    protected static final int JIMIIMAGE = 1;
    protected static final int IMAGEPRODUCER = 2;
    protected JimiReader reader;
    protected int type;
    protected boolean loadedFirstImage = false;
    protected boolean error = false;
    protected Object prev;

    public boolean hasMoreElements() {
        return !this.error && (!this.loadedFirstImage || this.reader.hasMoreElements());
    }

    public Object nextElement() {
        return this.createNextElement();
    }

    public Object createNextElement() {
        this.loadedFirstImage = true;
        if (this.type == 1) {
            try {
                return this.reader.getNextJimiImage();
            }
            catch (JimiException jimiException) {
                this.error = true;
                return null;
            }
        }
        if (this.type == 0) {
            try {
                return this.reader.getNextImage();
            }
            catch (JimiException jimiException) {
                this.error = true;
                return JimiUtil.getErrorImage();
            }
        }
        if (this.type == 2) {
            try {
                return this.reader.getNextImageProducer();
            }
            catch (JimiException jimiException) {
                this.error = true;
                return JimiUtil.getErrorImageProducer();
            }
        }
        return null;
    }

    public ImageSeriesEnumerator(JimiReader jimiReader, int n) {
        this.reader = jimiReader;
        this.type = n;
    }
}

