/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.service.AbstractBrowse;
import org.greenstone.gsdl3.util.DBInfo;
import org.greenstone.gsdl3.util.GS2MacroResolver;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.OID;
import org.greenstone.gsdl3.util.SimpleCollectionDatabase;
import org.w3c.dom.Element;

public class GS2Browse
extends AbstractBrowse {
    static Logger logger = Logger.getLogger((String)GS2Browse.class.getName());
    protected SimpleCollectionDatabase coll_db = null;

    public void cleanUp() {
        super.cleanUp();
        this.coll_db.closeDatabase();
    }

    public boolean configure(Element info, Element extra_info) {
        if (!super.configure(info, extra_info)) {
            return false;
        }
        logger.info((Object)"Configuring GS2Browse...");
        Element index_stem_elem = (Element)GSXML.getChildByTagName(info, "indexStem");
        String index_stem = null;
        if (index_stem_elem != null) {
            index_stem = index_stem_elem.getAttribute("name");
        }
        if (index_stem == null || index_stem.equals("")) {
            index_stem = this.cluster_name;
        }
        Element database_type_elem = (Element)GSXML.getChildByTagName(info, "databaseType");
        String database_type = null;
        if (database_type_elem != null) {
            database_type = database_type_elem.getAttribute("name");
        }
        if (database_type == null || database_type.equals("")) {
            database_type = "gdbm";
        }
        this.coll_db = new SimpleCollectionDatabase(database_type);
        if (this.coll_db == null) {
            logger.error((Object)("Couldn't create the collection database of type " + database_type));
            return false;
        }
        String coll_db_file = GSFile.collectionDatabaseFile(this.site_home, this.cluster_name, index_stem, database_type);
        if (!this.coll_db.openDatabase(coll_db_file, 0)) {
            logger.error((Object)"Could not open collection database!");
            return false;
        }
        this.macro_resolver = new GS2MacroResolver(this.coll_db);
        return true;
    }

    protected String translateId(String node_id) {
        return this.coll_db.translateOID(node_id);
    }

    protected String getDocType(String node_id) {
        boolean is_leaf;
        DBInfo info = this.coll_db.getInfo(node_id);
        if (info == null) {
            return "simple";
        }
        String doc_type = info.getInfo("doctype");
        if (!doc_type.equals("") && !doc_type.equals("doc")) {
            return doc_type;
        }
        String top_id = OID.getTop(node_id);
        boolean is_top = top_id.equals(node_id);
        String children = info.getInfo("contains");
        boolean bl = is_leaf = children.equals("");
        if (is_top && is_leaf) {
            return "simple";
        }
        if (!is_top) {
            info = this.coll_db.getInfo(top_id);
        }
        if (info == null) {
            return "hierarchy";
        }
        String childtype = info.getInfo("childtype");
        if (childtype.equals("Paged")) {
            return "paged";
        }
        return "hierarchy";
    }

    protected String getRootId(String node_id) {
        return OID.getTop(node_id);
    }

    protected ArrayList getChildrenIds(String node_id) {
        DBInfo info = this.coll_db.getInfo(node_id);
        if (info == null) {
            return null;
        }
        ArrayList<String> children = new ArrayList<String>();
        String contains = info.getInfo("contains");
        StringTokenizer st = new StringTokenizer(contains, ";");
        while (st.hasMoreTokens()) {
            String child_id = st.nextToken().replaceAll("\"", node_id);
            children.add(child_id);
        }
        return children;
    }

    protected String getParentId(String node_id) {
        String parent = OID.getParent(node_id);
        if (parent.equals(node_id)) {
            return null;
        }
        return parent;
    }

    protected String getMetadata(String node_id, String key) {
        DBInfo info = this.coll_db.getInfo(node_id);
        if (info == null) {
            return "";
        }
        Set keys = info.getKeys();
        for (String key_in : keys) {
            String value = info.getInfo(key);
            if (!key_in.equals(key)) continue;
            return value;
        }
        return "";
    }

    protected Element getMetadataList(String node_id, boolean all_metadata, ArrayList metadata_names) {
        String lang = "en";
        Element metadata_list = this.doc.createElement("metadataList");
        DBInfo info = this.coll_db.getInfo(node_id);
        if (info == null) {
            return null;
        }
        if (all_metadata) {
            Set keys = info.getKeys();
            for (String key : keys) {
                String value = info.getInfo(key);
                GSXML.addMetadata(this.doc, metadata_list, key, this.macro_resolver.resolve(value, lang, "metadata", node_id));
            }
        } else {
            for (int i = 0; i < metadata_names.size(); ++i) {
                String meta_name = (String)metadata_names.get(i);
                String value = info.getInfo(meta_name);
                GSXML.addMetadata(this.doc, metadata_list, meta_name, value);
            }
        }
        return metadata_list;
    }

    protected String getStructureInfo(String doc_id, String info_type) {
        String value = "";
        if (info_type.equals("numSiblings")) {
            String parent_id = OID.getParent(doc_id);
            value = parent_id.equals(doc_id) ? "0" : String.valueOf(this.getNumChildren(parent_id));
            return value;
        }
        if (info_type.equals("numChildren")) {
            return String.valueOf(this.getNumChildren(doc_id));
        }
        if (info_type.equals("siblingPosition")) {
            String parent_id = OID.getParent(doc_id);
            if (parent_id.equals(doc_id)) {
                return "-1";
            }
            DBInfo info = this.coll_db.getInfo(parent_id);
            if (info == null) {
                return "-1";
            }
            String contains = info.getInfo("contains");
            contains = contains.replaceAll("\"", parent_id);
            String[] children = contains.split(";");
            for (int i = 0; i < children.length; ++i) {
                String child_id = children[i];
                if (!child_id.equals(doc_id)) continue;
                return String.valueOf(i + 1);
            }
            return "-1";
        }
        return null;
    }

    protected int getNumChildren(String node_id) {
        DBInfo info = this.coll_db.getInfo(node_id);
        if (info == null) {
            return 0;
        }
        String contains = info.getInfo("contains");
        if (contains.equals("")) {
            return 0;
        }
        String[] children = contains.split(";");
        return children.length;
    }

    protected boolean isDocumentId(String node_id) {
        return !node_id.startsWith("CL");
    }
}

