/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.service.AbstractSearch;
import org.greenstone.gsdl3.util.DBInfo;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.OID;
import org.greenstone.gsdl3.util.SimpleCollectionDatabase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractGS2Search
extends AbstractSearch {
    protected static final String EQUIV_TERM_ELEM = "equivTerm";
    protected static final String STEM_ATT = "stem";
    protected static final String NUM_DOCS_MATCH_ATT = "numDocsMatch";
    protected static final String FREQ_ATT = "freq";
    protected static final String DEFAULT_INDEX_ELEM = "defaultIndex";
    protected static final String INDEX_STEM_ELEM = "indexStem";
    protected static final String INDEX_ELEM = "index";
    protected static final String DEFAULT_INDEX_SUBCOLLECTION_ELEM = "defaultIndexSubcollection";
    protected static final String DEFAULT_INDEX_LANGUAGE_ELEM = "defaultIndexLanguage";
    protected static final String INDEX_SUBCOLLECTION_ELEM = "indexSubcollection";
    protected static final String INDEX_LANGUAGE_ELEM = "indexLanguage";
    protected static final String STEMINDEX_OPTION = "stemIndexes";
    protected static final String MAXNUMERIC_OPTION = "maxnumeric";
    protected String index_stem = null;
    protected boolean does_case = true;
    protected boolean does_stem = true;
    protected boolean does_accent = false;
    protected int maxnumeric = 4;
    protected SimpleCollectionDatabase coll_db = null;
    static Logger logger = Logger.getLogger((String)AbstractGS2Search.class.getName());

    public void cleanUp() {
        super.cleanUp();
        this.coll_db.closeDatabase();
    }

    public boolean configure(Element info, Element extra_info) {
        Element index_option_list;
        Element defLang;
        Element defSub;
        String coll_db_file;
        if (!super.configure(info, extra_info)) {
            return false;
        }
        Element database_type_elem = (Element)GSXML.getChildByTagName(info, "databaseType");
        String database_type = null;
        if (database_type_elem != null) {
            database_type = database_type_elem.getAttribute("name");
        }
        if (database_type == null || database_type.equals("")) {
            database_type = "gdbm";
        }
        this.coll_db = new SimpleCollectionDatabase(database_type);
        if (this.coll_db == null) {
            logger.error((Object)("Couldn't create the collection database of type " + database_type));
            return false;
        }
        Element index_stem_elem = (Element)GSXML.getChildByTagName(info, INDEX_STEM_ELEM);
        if (index_stem_elem != null) {
            this.index_stem = index_stem_elem.getAttribute("name");
        }
        if (this.index_stem == null || this.index_stem.equals("")) {
            logger.warn((Object)"indexStem element not found, stem will default to collection name");
            this.index_stem = this.cluster_name;
        }
        if (!this.coll_db.openDatabase(coll_db_file = GSFile.collectionDatabaseFile(this.site_home, this.cluster_name, this.index_stem, database_type), 0)) {
            logger.error((Object)"Could not open collection database!");
            return false;
        }
        this.does_chunking = true;
        Element def = (Element)GSXML.getChildByTagName(info, DEFAULT_INDEX_ELEM);
        if (def != null) {
            this.default_index = def.getAttribute("shortname");
        }
        if ((defSub = (Element)GSXML.getChildByTagName(info, DEFAULT_INDEX_SUBCOLLECTION_ELEM)) != null) {
            this.default_index_subcollection = defSub.getAttribute("shortname");
        }
        if ((defLang = (Element)GSXML.getChildByTagName(info, DEFAULT_INDEX_LANGUAGE_ELEM)) != null) {
            this.default_index_language = defLang.getAttribute("shortname");
        }
        if ((index_option_list = (Element)GSXML.getChildByTagName(info, "indexOptionList")) != null) {
            NodeList options = index_option_list.getElementsByTagName("indexOption");
            for (int i = 0; i < options.getLength(); ++i) {
                Element opt = (Element)options.item(i);
                String name = opt.getAttribute("name");
                String value = opt.getAttribute("value");
                if (name.equals(MAXNUMERIC_OPTION)) {
                    int maxnum = Integer.parseInt(value);
                    if (4 > maxnum || maxnum >= 512) continue;
                    this.maxnumeric = maxnum;
                    continue;
                }
                if (!name.equals(STEMINDEX_OPTION)) continue;
                int stemindex = Integer.parseInt(value);
                if ((stemindex & 1) == 0) {
                    this.does_case = false;
                }
                if ((stemindex & 2) == 0) {
                    this.does_stem = false;
                }
                if ((stemindex & 4) == 0) continue;
                this.does_accent = true;
            }
        }
        if (extra_info != null) {
            Document owner = info.getOwnerDocument();
            NodeList indexes = info.getElementsByTagName(INDEX_ELEM);
            Element config_search = (Element)GSXML.getChildByTagName(extra_info, "search");
            for (int i = 0; i < indexes.getLength(); ++i) {
                Element ind = (Element)indexes.item(i);
                String name = ind.getAttribute("name");
                Element node_extra = GSXML.getNamedElement(config_search, INDEX_ELEM, "name", name);
                if (node_extra == null) {
                    logger.error((Object)("haven't found extra info for index named " + name));
                    continue;
                }
                NodeList display_names = node_extra.getElementsByTagName("displayItem");
                if (display_names == null) continue;
                for (int j = 0; j < display_names.getLength(); ++j) {
                    Element e = (Element)display_names.item(j);
                    ind.appendChild(owner.importNode(e, true));
                }
            }
        }
        return true;
    }

    protected void getIndexData(ArrayList index_ids, ArrayList index_names, String lang) {
        Element index_list = (Element)GSXML.getChildByTagName(this.config_info, "indexList");
        NodeList indexes = index_list.getElementsByTagName(INDEX_ELEM);
        int len = indexes.getLength();
        for (int i = 0; i < len; ++i) {
            Element index = (Element)indexes.item(i);
            String shortname = index.getAttribute("shortname");
            if (shortname.equals("")) continue;
            index_ids.add(shortname);
            String display_name = GSXML.getDisplayText(index, "name", lang, "en");
            if (display_name.equals("") && (display_name = index.getAttribute("name")).equals("")) {
                display_name = shortname;
            }
            index_names.add(display_name);
        }
    }

    protected void getIndexSubcollectionData(ArrayList index_sub_ids, ArrayList index_sub_names, String lang) {
        Element index_sub_list = (Element)GSXML.getChildByTagName(this.config_info, "indexSubcollectionList");
        NodeList index_subs = index_sub_list.getElementsByTagName(INDEX_SUBCOLLECTION_ELEM);
        int len = index_subs.getLength();
        for (int i = 0; i < len; ++i) {
            Element indexsub = (Element)index_subs.item(i);
            String shortname = indexsub.getAttribute("shortname");
            if (shortname.equals("")) continue;
            index_sub_ids.add(shortname);
            String display_name = GSXML.getDisplayText(indexsub, "name", lang, "en");
            if (display_name.equals("") && (display_name = indexsub.getAttribute("name")).equals("")) {
                display_name = shortname;
            }
            index_sub_names.add(display_name);
        }
    }

    protected void getIndexLanguageData(ArrayList index_lang_ids, ArrayList index_lang_names, String lang) {
        Element index_lang_list = (Element)GSXML.getChildByTagName(this.config_info, "indexLanguageList");
        NodeList index_langs = index_lang_list.getElementsByTagName(INDEX_LANGUAGE_ELEM);
        int len = index_langs.getLength();
        for (int i = 0; i < len; ++i) {
            Element indexlang = (Element)index_langs.item(i);
            String shortname = indexlang.getAttribute("shortname");
            if (shortname.equals("")) continue;
            index_lang_ids.add(shortname);
            String display_name = GSXML.getDisplayText(indexlang, "name", lang, "en");
            if (display_name.equals("") && (display_name = indexlang.getAttribute("name")).equals("")) {
                display_name = shortname;
            }
            index_lang_names.add(display_name);
        }
    }

    protected void addCustomQueryParams(Element param_list, String lang) {
        if (this.does_case) {
            this.createParameter("case", param_list, lang);
        }
        if (this.does_stem) {
            this.createParameter(STEM_ATT, param_list, lang);
        }
        if (this.does_accent) {
            this.createParameter("accent", param_list, lang);
        }
        this.createParameter("matchMode", param_list, lang);
    }

    protected String getDocType(String node_id) {
        boolean is_leaf;
        DBInfo info = this.coll_db.getInfo(node_id);
        if (info == null) {
            return "simple";
        }
        String doc_type = info.getInfo("doctype");
        if (!doc_type.equals("") && !doc_type.equals("doc")) {
            return doc_type;
        }
        String top_id = OID.getTop(node_id);
        boolean is_top = top_id.equals(node_id);
        String children = info.getInfo("contains");
        boolean bl = is_leaf = children.equals("");
        if (is_top && is_leaf) {
            return "simple";
        }
        if (!is_top) {
            info = this.coll_db.getInfo(top_id);
        }
        if (info == null) {
            return "hierarchy";
        }
        String childtype = info.getInfo("childtype");
        if (childtype.equals("Paged")) {
            return "paged";
        }
        return "hierarchy";
    }

    protected boolean hasChildren(String node_id) {
        DBInfo info = this.coll_db.getInfo(node_id);
        if (info == null) {
            return false;
        }
        String contains = info.getInfo("contains");
        return !contains.equals("");
    }

    protected boolean hasParent(String node_id) {
        String parent = OID.getParent(node_id);
        return !parent.equals(node_id);
    }

    protected String internalNum2OID(long docnum) {
        return this.coll_db.docnum2OID(docnum);
    }

    protected String internalNum2OID(String docnum) {
        return this.coll_db.docnum2OID(docnum);
    }
}

