/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.selfContained;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.greenstone.gsdl3.selfContained.Increment;

public final class IncrementRange
extends Increment
implements Cloneable,
Serializable {
    private char first = (char)32;
    private char last = (char)122;

    IncrementRange(char first, char last) {
        this.first = first;
        this.last = last;
    }

    IncrementRange() {
    }

    IncrementRange(boolean b) {
        this.first = '\u0000';
        this.last = (char)65535;
    }

    long incrementStream(Reader rdr, Writer wtr) {
        try {
            long count = 0L;
            int i = rdr.read();
            boolean carry = true;
            while (i != -1) {
                char c = (char)i;
                if (c < this.first || c > this.last) {
                    throw new Error("Character '" + c + "' is ouside range");
                }
                if (c == this.last) {
                    if (carry) {
                        wtr.write(this.first);
                        carry = true;
                    } else {
                        wtr.write(c);
                        carry = false;
                    }
                } else if (carry) {
                    c = (char)(c + '\u0001');
                    wtr.write(c);
                    carry = false;
                } else {
                    wtr.write(c);
                    carry = false;
                }
                ++count;
                i = rdr.read();
            }
            if (carry) {
                wtr.write(this.first);
                ++count;
            }
            return count;
        }
        catch (IOException e) {
            System.err.println("IOException in incrementStream()");
            throw new Error(e.toString());
        }
    }

    public final String incrementString(String str) {
        StringBuffer buffer = new StringBuffer();
        if (str.equals("")) {
            buffer.append(this.first);
            return buffer.toString();
        }
        boolean carry = true;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c < this.first || c > this.last) {
                throw new Error("Character '" + c + "' is ouside range");
            }
            if (c == this.last) {
                if (carry) {
                    buffer.append(this.first);
                    carry = true;
                    continue;
                }
                buffer.append(c);
                carry = false;
                continue;
            }
            if (carry) {
                c = (char)(c + '\u0001');
                buffer.append(c);
                carry = false;
                continue;
            }
            buffer.append(c);
            carry = false;
        }
        if (carry) {
            buffer.append(this.first);
        }
        return buffer.toString();
    }

    public static void testStringIncrement() throws IOException {
        IncrementRange n = new IncrementRange();
        try {
            String tmp = "";
            System.out.println(IncrementRange.stringToHex(tmp));
            while (true) {
                tmp = n.incrementString(tmp);
                n.checkStr(tmp);
            }
        }
        catch (Exception e) {
            System.out.println("Caught exception: " + e);
            return;
        }
    }

    public static void testStreamIncrement() {
        IncrementRange n = new IncrementRange();
        try {
            long counter = 0L;
            String tmp = "";
            System.out.println(IncrementRange.stringToHex(tmp));
            while (true) {
                String tmp2 = n.incrementString(tmp);
                StringWriter wtr = new StringWriter();
                n.incrementStream(new StringReader(tmp), wtr);
                if (!tmp2.equals(wtr.toString())) {
                    throw new Exception("Error: \"" + tmp2 + "\" and \"" + tmp2 + "\"");
                }
                if (++counter % 1000000L == 0L) {
                    System.out.println(counter + " " + tmp);
                }
                tmp = tmp2;
            }
        }
        catch (Exception e) {
            System.out.println("Caught exception: " + e);
            return;
        }
    }

    public static void main(String[] args) {
        IncrementRange.testStreamIncrement();
    }
}

