/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.selfContained;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.greenstone.gsdl3.selfContained.DocumentStream;
import org.greenstone.gsdl3.selfContained.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class FilesDocumentStream
implements DocumentStream {
    Vector files = new Vector();
    Vector directories = new Vector();

    public FilesDocumentStream(String filename) {
        File file = new File(filename);
        if (file.exists() && file.isDirectory()) {
            this.directories.add(file.getAbsolutePath());
        } else {
            this.files.add(file.getAbsolutePath());
        }
    }

    public FilesDocumentStream(File file) {
        if (file.exists() && file.isDirectory()) {
            this.directories.add(file.getAbsolutePath());
        } else {
            this.files.add(file.getAbsolutePath());
        }
    }

    protected void expandIfNecessary() {
        while (this.directories.size() > 0) {
            File file;
            int i;
            String dirname = (String)this.directories.elementAt(0);
            this.directories.removeElement(dirname);
            File dir = new File(dirname);
            if (!dir.exists()) {
                throw new Error("error in expand: expecting a directory " + dirname);
            }
            String[] fileArray = dir.list();
            for (i = 0; i < fileArray.length; ++i) {
                file = new File(dir, fileArray[i]);
                if (!file.exists() || !file.isDirectory()) continue;
                this.directories.add(file.getPath());
            }
            fileArray = dir.list(new XMLFilenameFilter());
            for (i = 0; i < fileArray.length; ++i) {
                file = new File(dir, fileArray[i]);
                if (!file.exists() || file.isDirectory()) continue;
                this.files.add(file.getPath());
            }
            if (this.files.size() <= 0) continue;
            return;
        }
    }

    public Document nextDocument() throws Exception {
        if (!this.hasNextDocument()) {
            throw new Error("Doesn't have another Document");
        }
        String filename = (String)this.files.elementAt(this.files.size() - 1);
        this.files.removeElementAt(this.files.size() - 1);
        File file = new File(filename);
        FileReader reader = new FileReader(file);
        InputSource xml_source = new InputSource(reader);
        XMLUtil.getDOMParser().parse(xml_source);
        Document doc = XMLUtil.getDOMParser().getDocument();
        return doc;
    }

    public boolean hasNextDocument() throws Exception {
        this.expandIfNecessary();
        return this.files.size() > 0;
    }

    public static void main(String[] args) throws Exception {
        StreamResult result = new StreamResult(System.out);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        FilesDocumentStream stream = new FilesDocumentStream(".");
        while (stream.hasNextDocument()) {
            Document document = stream.nextDocument();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
            System.out.println();
            System.out.println();
        }
    }

    class XMLFilenameFilter
    implements FilenameFilter {
        XMLFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            String target = ".xml";
            if (name.length() < target.length()) {
                return false;
            }
            String extension = name.substring(name.length() - 4, name.length());
            return extension.equalsIgnoreCase(target);
        }
    }
}

