/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Set;
import org.greenstone.gsdl3.core.DefaultReceptionist;
import org.greenstone.gsdl3.core.MessageRouter;
import org.greenstone.gsdl3.util.GSParams;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Library2 {
    protected XMLConverter converter = new XMLConverter();
    protected Document doc = null;
    protected HashMap saved_args = null;
    protected GSParams params = null;
    protected DefaultReceptionist recept = null;

    public Library2() {
        Library2 library2 = this;
        this.doc = library2.converter.newDOM();
        this.saved_args = new HashMap();
        this.params = new GSParams();
        this.recept = new DefaultReceptionist();
    }

    public void configure(String site_name, String interface_name) {
        HashMap<String, String> config_params = new HashMap<String, String>();
        config_params.put("site_name", site_name);
        config_params.put("interface_name", interface_name);
        MessageRouter message_router = new MessageRouter();
        message_router.setSiteName(site_name);
        message_router.configure();
        this.recept.setConfigParams(config_params);
        this.recept.setMessageRouter(message_router);
        this.recept.setParams(this.params);
        this.recept.configure();
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: Library2 <site name> <interface name>");
            System.exit(1);
        }
        Library2 library = new Library2();
        library.configure(args[0], args[1]);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String query = null;
        String result = null;
        while (true) {
            System.out.println("Please enter the  cgi args (all on one line), or 'exit' to quit (default a=p&sa=home)");
            try {
                query = br.readLine();
            }
            catch (Exception e) {
                System.err.println("Library2 exception:" + e.getMessage());
            }
            if (query.startsWith("exit")) {
                System.exit(1);
            }
            result = library.process(query);
            System.out.println(result);
        }
    }

    protected String process(String query) {
        Element xml_message = this.generateRequest(query);
        System.out.println("*********************");
        System.out.println(XMLConverter.getPrettyString(xml_message));
        Node xml_result = this.recept.process(xml_message);
        return XMLConverter.getPrettyString(xml_result);
    }

    protected Element generateRequest(String cgiargs) {
        Element xml_message = this.doc.createElement("message");
        Element xml_request = GSXML.createBasicRequest(this.doc, "page", "", "", "");
        xml_message.appendChild(xml_request);
        Element xml_param_list = this.doc.createElement("paramList");
        xml_request.appendChild(xml_param_list);
        String action = "p";
        String subaction = "home";
        String lang = (String)this.saved_args.get("l");
        if (lang == null) {
            lang = "en";
        }
        String output = "html";
        String[] args = cgiargs.split("&");
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            int pos = arg.indexOf(61);
            if (pos == -1) continue;
            String name = arg.substring(0, pos);
            String value = arg.substring(pos + 1);
            if (name.equals("a")) {
                action = value;
                continue;
            }
            if (name.equals("sa")) {
                subaction = value;
                continue;
            }
            if (name.equals("l")) {
                lang = value;
                this.saved_args.put(name, value);
                continue;
            }
            if (name.equals("o")) {
                output = value;
                continue;
            }
            if (this.params.shouldSave(name)) {
                this.saved_args.put(name, value);
                continue;
            }
            Element param = this.doc.createElement("param");
            param.setAttribute("name", name);
            param.setAttribute("value", GSXML.xmlSafe(value));
            xml_param_list.appendChild(param);
        }
        xml_request.setAttribute("output", output);
        xml_request.setAttribute("action", action);
        xml_request.setAttribute("subaction", subaction);
        xml_request.setAttribute("lang", lang);
        Set params = this.saved_args.keySet();
        for (String name : params) {
            if (name.equals("l")) continue;
            Element param = this.doc.createElement("param");
            param.setAttribute("name", name);
            param.setAttribute("value", GSXML.xmlSafe((String)this.saved_args.get(name)));
            xml_param_list.appendChild(param);
        }
        return xml_message;
    }
}

