/**********************************************************************
 *
 * configaction.h -- 
 * Copyright (C) 2003 DL Consulting Ltd
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef CONFIGACTION_H
#define CONFIGACTION_H

#include "action.h"
#include "receptionist.h"

class configaction : public action {

protected:
  receptionist *recpt;

  void create_colservr (const text_t &collection, ostream &logout);
  void remove_colservr (const text_t &collection, ostream &logout);

public:
  configaction ();
  virtual ~configaction ();

  void set_receptionist (receptionist *therecpt) {recpt=therecpt;}

  text_t get_action_name () {return "config";}
  void get_cgihead_info (cgiargsclass &args, recptprotolistclass *protos,
			 response_t &response, text_t &response_data, 
			 ostream &logout);

  bool do_action (cgiargsclass &args, recptprotolistclass *protos, 
		  browsermapclass *browsers, displayclass &disp,
		  outconvertclass &outconvert, ostream &textout,
		  ostream &logout);
};



#endif
