/**********************************************************************
 *
 * metaformat.h --
 *
 * Copyright (C) 2004-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

/**
 *  A framework class for metadata formats.
 *
 *  Example child classes include oaimeta and rfc8507meta
 */

#ifndef _METAFORMAT_H_
#define _METAFORMAT_H_
#include <stdio.h>

#include "text_t.h"
#include "comtypes.h"
#include "recptproto.h"

#include "oaiconfig.h"

class metaformat
{  
 protected:
  virtual void output_metadata_header(ostream &output) = 0;
  virtual void output_item(ostream &output, outconvertclass &outconvert, 
			   bool &headerDone, const text_t &label, 
			   const text_tarray &values);
  virtual void output_metadata_footer(ostream &output) = 0;
  virtual bool is_valid_element(text_t &meta_name);
  virtual bool scan_metadata(ostream &output, const text_t &collection,  
			     ResultDocInfo_t &docInfo, bool doOutput);
  virtual bool output_custom_metadata(ostream &output, outconvertclass &outconvert, bool &headerDone, const text_t &collection, 
			       ResultDocInfo_t &docInfo);
  text_t get_metadata_value(ResultDocInfo_t &docInfo, const text_t &meta_name);
  void get_metadata_values(ResultDocInfo_t &docInfo, const text_t &meta_name, text_tarray & values);
  oaiconfig *    oaiConfigure;

  // a set containing all the valid element names for the set. Must be 
  // initialized by each metadata class
  text_tset elementSet; 

 public:
  metaformat(); // Must be given the desired oai version when created 
  virtual const text_t formatName() = 0;
  virtual const text_t formatPrefix() = 0;
  virtual bool output_record(ostream &output, recptproto *protocol, 
			     const text_t &collection, 
			     const text_t &record_OID);
  virtual bool is_available(const text_t &collection, ResultDocInfo_t &docInfo);
  virtual bool output_metadata(ostream &output, const text_t &collection,  
			       ResultDocInfo_t &docInfo);
  virtual bool output_formatdata(ostream &output) = 0;
  void    set_configuration(oaiconfig *config) { this->oaiConfigure = config; }
  text_t  get_mapping(const text_t &collection, const text_t &collectionField);
  virtual ~metaformat() { this->oaiConfigure = NULL; }
};

class metaformatptr
{
 public:
  metaformat *ptr;

  metaformatptr() { this->ptr = NULL; }
  metaformat *get_class() { return this->ptr; }
  void set_class(metaformat *ptr) { this->ptr = ptr; }
  void set_configuration(oaiconfig *config) { this->ptr->set_configuration(config);}
  void clear() { delete this->ptr; this->ptr = NULL; }
};

typedef	map<text_t, metaformatptr, lttext_t> metaformat_map;

#endif
