/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.sql.derby;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.sql.SQLServer;

public class DerbySQLServer
implements SQLServer {
    static final String PROTOCOL = "jdbc:derby:";
    static final String DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    static Logger logger = Logger.getLogger((String)DerbySQLServer.class.getName());

    public DerbySQLServer() {
        try {
            Class.forName(DRIVER).newInstance();
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't find derby driver: org.apache.derby.jdbc.EmbeddedDriver", (Throwable)e);
        }
    }

    public Connection connect(String databasePath) {
        try {
            String protocol_str = PROTOCOL + databasePath;
            Connection connection = DriverManager.getConnection(protocol_str);
            return connection;
        }
        catch (Exception e) {
            logger.info((Object)("Connect to database " + databasePath + " failed!"));
            return null;
        }
    }

    public Connection connectAndCreate(String databasePath) {
        try {
            String protocol_str = PROTOCOL + databasePath + ";create=true";
            Connection connection = DriverManager.getConnection(protocol_str);
            return connection;
        }
        catch (Exception e) {
            logger.error((Object)("Connect to database " + databasePath + " failed!"), (Throwable)e);
            return null;
        }
    }

    public boolean disconnect(String databasePath) {
        try {
            String protocol_str = PROTOCOL + databasePath + ";shutdown=true";
            DriverManager.getConnection(protocol_str);
        }
        catch (SQLException se) {
            String theError = se.getSQLState();
            if (!theError.equals("08006")) {
                logger.error((Object)("Database " + databasePath + " couldn't be shut down properly!"), (Throwable)se);
            }
            return true;
        }
        return false;
    }
}

