/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.bmp;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.bmp.BMPColorMap;
import com.sun.jimi.core.decoder.bmp.BMPFileHeader;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.LEDataInputStream;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BMPDecoder
extends JimiDecoderBase {
    private AdaptiveRasterImage f1;
    private InputStream f2;
    private LEDataInputStream f3;
    private int f4;
    private BMPFileHeader f5;
    private BMPColorMap f6;
    private ColorModel f7;
    byte[] rawScanLine;
    int[] intScanLine;
    byte[] byteScanLine;

    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        this.f5 = null;
        this.f6 = null;
        this.f2 = inputStream;
        this.f3 = new LEDataInputStream(new BufferedInputStream(this.f2));
        this.f1 = adaptiveRasterImage;
        this.f4 = 0;
    }

    public boolean driveDecoder() throws JimiException {
        try {
            this.f5 = new BMPFileHeader(this.f3);
            this.f6 = new BMPColorMap(this.f3, this.f5);
            this.m1();
            this.f4 |= 2;
            BMPDecoder bMPDecoder = this;
            bMPDecoder.m2(bMPDecoder.f3);
            this.f1.addFullCoverage();
            this.f4 |= 4;
        }
        catch (IOException iOException) {
            this.f4 |= 1;
            throw new JimiException("IO error reading BMP file");
        }
        catch (JimiException jimiException) {
            this.f4 |= 1;
            throw jimiException;
        }
        return false;
    }

    public void freeDecoder() throws JimiException {
        this.f2 = null;
        this.f1 = null;
    }

    public int getState() {
        return this.f4;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.f1;
    }

    private void m1() throws JimiException {
        this.f1.setSize(this.f5.width, this.f5.height);
        if (this.f5.bitsPerPixel == 32) {
            this.f7 = ColorModel.getRGBdefault();
        } else if (this.f5.bitsPerPixel == 24) {
            this.f7 = new DirectColorModel(24, 0xFF0000, 65280, 255);
        } else if (this.f5.bitsPerPixel == 16) {
            this.f7 = new DirectColorModel(16, this.f5.redMask, this.f5.greenMask, this.f5.blueMask, this.f5.alphaMask);
        } else {
            if (this.f6.noOfEntries <= 0) {
                throw new JimiException("8 bit or less bitsperpixel requies pallete");
            }
            this.f7 = new IndexColorModel(8, this.f6.noOfEntries, this.f6.r, this.f6.g, this.f6.b);
        }
        this.f1.setColorModel(this.f7);
        this.f1.setPixels();
        if (this.f5.bitsPerPixel == 32) {
            this.intScanLine = new int[this.f5.scanLineSize >> 2];
        }
        if (this.f5.bitsPerPixel == 24) {
            this.intScanLine = new int[this.f5.scanLineSize / 3];
        }
        if (this.f5.bitsPerPixel == 16) {
            this.intScanLine = new int[this.f5.scanLineSize >> 1];
        } else {
            this.byteScanLine = new byte[this.f5.width];
        }
        this.rawScanLine = new byte[this.f5.scanLineSize];
    }

    private void m2(LEDataInputStream lEDataInputStream) throws JimiException, IOException {
        switch (this.f5.compression) {
            case 0: {
                break;
            }
            case 1: {
                this.f1.setChannel(0L);
                this.unpackRLE8(lEDataInputStream);
                return;
            }
            case 2: {
                this.f1.setChannel(0L);
                this.unpackRLE4(lEDataInputStream);
                return;
            }
            case 3: {
                break;
            }
            default: {
                throw new JimiException("Unsupported compression " + this.f5.compression);
            }
        }
        int n = this.f5.height - 1;
        while (n >= 0) {
            lEDataInputStream.readFully(this.rawScanLine, 0, this.f5.scanLineSize);
            if (this.f5.bitsPerPixel == 32) {
                BMPDecoder bMPDecoder = this;
                bMPDecoder.m5(bMPDecoder.rawScanLine, 0, this.intScanLine, 0, this.f5.width);
                this.f1.setChannel(n, this.intScanLine);
            } else if (this.f5.bitsPerPixel == 24) {
                BMPDecoder bMPDecoder = this;
                bMPDecoder.m4(bMPDecoder.rawScanLine, 0, this.intScanLine, 0, this.f5.width);
                this.f1.setChannel(n, this.intScanLine);
            } else if (this.f5.bitsPerPixel == 16) {
                BMPDecoder bMPDecoder = this;
                bMPDecoder.m3(bMPDecoder.rawScanLine, 0, this.intScanLine, 0, this.f5.width);
                this.f1.setChannel(n, this.intScanLine);
            } else if (this.f5.bitsPerPixel < 8) {
                JimiUtil.expandPixels(this.f5.bitsPerPixel, this.rawScanLine, this.byteScanLine, this.f5.width);
                this.f1.setChannel(0, n, this.byteScanLine);
            } else {
                this.f1.setChannel(0, n, this.rawScanLine, 0, this.f5.width);
            }
            BMPDecoder bMPDecoder = this;
            bMPDecoder.setProgress((bMPDecoder.f5.height - n - 1) * 100 / (this.f5.height - 1));
            --n;
        }
    }

    private void m3(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n;
        int n6 = 255;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = byArray[n5++] & n6;
            int n9 = (byArray[n5++] & n6) << 8;
            nArray[n4] = n8 | n9;
            ++n4;
            ++n7;
        }
    }

    private void m4(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n;
        int n6 = 255;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = byArray[n5++] & n6;
            int n9 = (byArray[n5++] & n6) << 8;
            int n10 = (byArray[n5++] & n6) << 16;
            nArray[n4] = 0xFF000000 | n8 | n9 | n10;
            ++n4;
            ++n7;
        }
    }

    private void m5(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n;
        int n6 = 255;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = byArray[n5++] & n6;
            int n9 = (byArray[n5++] & n6) << 8;
            int n10 = (byArray[n5++] & n6) << 16;
            ++n5;
            nArray[n4] = 0xFF000000 | n8 | n9 | n10;
            ++n4;
            ++n7;
        }
    }

    /*
     * Unable to fully structure code
     */
    void unpackRLE8(InputStream var1_1) throws JimiException, IOException {
        var8_2 = this.f5.height - 1;
        var9_3 = 0;
        var7_4 = new byte[this.f5.width];
        var10_5 = 0;
        block5: while (true) {
            if ((var3_6 = var1_1.read()) < 0) {
                throw new EOFException();
            }
            if (var3_6 == 0) {
                var5_8 = var1_1.read();
                if (var5_8 < 0) {
                    throw new EOFException();
                }
                switch (var5_8) {
                    case 0: {
                        if (var10_5 > var9_3) {
                            this.f1.setChannel(0, var9_3, var8_2, var10_5 - var9_3, 1, var7_4, var9_3, var7_4.length);
                        }
                        var10_5 = 0;
                        var9_3 = 0;
                        v0 = this;
                        v0.setProgress((v0.f5.height - 1 - --var8_2) * 100 / (this.f5.height - 1));
                        continue block5;
                    }
                    case 1: {
                        return;
                    }
                    case 2: {
                        this.f1.setChannel(0, var9_3, var8_2, var10_5 - var9_3, 1, var7_4, var9_3, var7_4.length);
                        var11_10 = var1_1.read();
                        var12_11 = var1_1.read();
                        var10_5 = var9_3 += var11_10;
                        var8_2 += var12_11;
                        continue block5;
                    }
                }
                var6_9 = false;
                if ((var5_8 & 1) != 0) {
                    var6_9 = true;
                }
                while (--var5_8 >= 0) {
                    var13_12 = var1_1.read();
                    if (var13_12 < 0) {
                        throw new EOFException();
                    }
                    if (var10_5 == var7_4.length) {
                        this.f1.setChannel(0, var9_3, var8_2, var10_5 - var9_3, 1, var7_4, var9_3, var7_4.length);
                        var10_5 = 0;
                        var9_3 = 0;
                        v1 = this;
                        v1.setProgress((v1.f5.height - 1 - --var8_2) * 100 / (this.f5.height - 1));
                    }
                    var7_4[var10_5++] = (byte)var13_12;
                }
                if (!var6_9) continue;
                var1_1.read();
                continue;
            }
            var4_7 = var1_1.read();
            if (var4_7 >= 0) ** GOTO lbl58
            throw new EOFException();
lbl-1000:
            // 1 sources

            {
                if (var10_5 == var7_4.length) {
                    this.f1.setChannel(0, var9_3, var8_2, var10_5 - var9_3, 1, var7_4, var9_3, var7_4.length);
                    var10_5 = 0;
                    var9_3 = 0;
                    --var8_2;
                }
                var7_4[var10_5++] = (byte)var4_7;
lbl58:
                // 2 sources

                ** while (--var3_6 >= 0)
            }
lbl59:
            // 1 sources

        }
    }

    /*
     * Unable to fully structure code
     */
    void unpackRLE4(InputStream var1_1) throws JimiException, IOException {
        var8_2 = this.f5.height - 1;
        var9_3 = 0;
        var7_4 = new byte[this.f5.width];
        var10_5 = 0;
        block5: while (true) {
            if ((var3_6 = var1_1.read()) < 0) {
                throw new EOFException();
            }
            if (var3_6 == 0) {
                var5_8 = var1_1.read();
                if (var5_8 < 0) {
                    throw new EOFException();
                }
                switch (var5_8) {
                    case 0: {
                        if (var10_5 > var9_3) {
                            this.f1.setChannel(0, var9_3, var8_2, var10_5 - var9_3, 1, var7_4, var9_3, var7_4.length);
                        }
                        var10_5 = 0;
                        var9_3 = 0;
                        --var8_2;
                        continue block5;
                    }
                    case 1: {
                        return;
                    }
                    case 2: {
                        if (var10_5 > var9_3) {
                            this.f1.setChannel(0, var9_3, var8_2, var10_5 - var9_3, 1, var7_4, var9_3, var7_4.length);
                        }
                        var11_10 = var1_1.read();
                        var12_12 = var1_1.read();
                        var10_5 = var9_3 += var11_10;
                        var8_2 += var12_12;
                        continue block5;
                    }
                }
                var6_9 = false;
                if ((var5_8 & 3) == 1 || (var5_8 & 3) == 2) {
                    var6_9 = true;
                }
                var13_13 = 0;
                var14_14 = new byte[2];
                while (--var5_8 >= 0) {
                    if (var13_13 == 0) {
                        var15_15 = var1_1.read();
                        if (var15_15 < 0) {
                            throw new EOFException();
                        }
                        var14_14[0] = (byte)((var15_15 & 240) >> 4);
                        var14_14[1] = (byte)(var15_15 & 15);
                    }
                    if (var10_5 == var7_4.length) {
                        if (var10_5 > var9_3) {
                            this.f1.setChannel(0, var9_3, var8_2, var10_5 - var9_3, 1, var7_4, var9_3, var7_4.length);
                        }
                        var10_5 = 0;
                        var9_3 = 0;
                        --var8_2;
                    }
                    var7_4[var10_5++] = var14_14[var13_13];
                    var13_13 ^= 1;
                }
                if (!var6_9) continue;
                var1_1.read();
                continue;
            }
            var4_7 = var1_1.read();
            if (var4_7 < 0) {
                throw new EOFException();
            }
            v0 = new byte[2];
            var11_11 = v0;
            v0[0] = (byte)((var4_7 & 240) >> 4);
            var11_11[1] = (byte)(var4_7 & 15);
            var12_12 = 0;
            while (true) {
                if (--var3_6 >= 0) ** break;
                continue block5;
                if (var10_5 == var7_4.length) {
                    if (var10_5 > var9_3) {
                        this.f1.setChannel(0, var9_3, var8_2, var10_5 - var9_3, 1, var7_4, var9_3, var7_4.length);
                    }
                    var10_5 = 0;
                    var9_3 = 0;
                    --var8_2;
                }
                var7_4[var10_5++] = var11_11[var12_12];
                var12_12 ^= 1;
            }
            break;
        }
    }

    public boolean usesChanneledData() {
        return true;
    }
}

