/**********************************************************************
 *
 * queryfilter.h -- abstract base class for queryfilters
 *          mgqueryfilter, mgppqueryfilter and lucenequeryfilter 
 *          implement this
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef QUERYFILTER_H
#define QUERYFILTER_H


#include "gsdlconf.h"
#include "text_t.h"
#include "comtypes.h"
#include "filter.h"
#include "dbclass.h"
#include "maptools.h"
#include "search.h"
#include "queryinfo.h"


class queryfilterclass : public filterclass {
protected:

  stringmap indexmap;
  stringmap subcollectionmap;
  stringmap languagemap;

  text_t db_filename;
  text_t indexstem;
  dbclass *db_ptr;
  
  searchclass *textsearchptr;

  int maxnumeric;

  virtual void set_queryparam_defaults(queryparamclass &query );
  virtual bool set_queryparam_field(const OptionValue_t &option, queryparamclass &query);
  virtual void parse_query_params (const FilterRequest_t &request,
			   vector<queryparamclass> &query_params,
			   int &startresults, int &endresults,
			   ostream &logout);

  // do query that might involve multiple sub queries
  // textsearchptr and db_ptr are assumed to be valid
  virtual void do_multi_query (const FilterRequest_t &request,
		       const vector<queryparamclass> &query_params,
		       queryresultsclass &multiresults,
		       comerror_t &err, ostream &logout)=0;

public:
  queryfilterclass ();
  virtual ~queryfilterclass ();

  // the db_ptr remains the responsibility of the calling code
  void set_db_ptr (dbclass *db_ptr_arg) { db_ptr = db_ptr_arg; }

  // the testsearchptr remains the responsability of the calling code
  void set_textsearchptr (searchclass *thetextsearchptr) {textsearchptr=thetextsearchptr;}

  virtual void configure (const text_t &key, const text_tarray &cfgline);
  virtual bool init (ostream &logout);

  text_t get_filter_name () {return "QueryFilter";}
  bool translate(dbclass *db_ptr, text_t& docnum, text_t &trans_OID);
  bool need_matching_docs (int filterResultOptions);
  bool need_term_info (int filterResultOptions);


  virtual void filter (const FilterRequest_t &request,
	       FilterResponse_t &response,
	       comerror_t &err, ostream &logout)=0;



};


#endif

