/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 *
 * Copyright (C) 2006 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;

public class GUIUtils {

    /** The name of the mouse listener that initiates editing on a double click. */
    static final private String SINGLE_CLICK_LISTENER = "SingleClickListener";

    /** Neat method to disable file renaming in filechooser.
     * Thanks to: vladi21 from www.experts-exchange.com
     */
    static public void disableRename(Component c) {
	if (c instanceof JList){
	    EventListener[] listeners=c.getListeners(MouseListener.class);
	    for(int i=0; listeners != null && i < listeners.length; i++) {
		if (listeners[i].toString().indexOf(SINGLE_CLICK_LISTENER) != -1) {
		    c.removeMouseListener((MouseListener)listeners[i]);
		}
	    }
	    return;
	}
	if (c instanceof Container) {
	    Component[] children = null;
	    children = ((Container)c).getComponents();
	    if (children != null) {
		for(int i = 0; children != null && i < children.length; i++) {
		    disableRename(children[i]);
		}
	    }
	}
    }


}
