/**********************************************************************
 *
 * DLLCode.h
 * Copyright (C) 2003  UNESCO
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

/////////////////////////////////////////////////////////////////////////////
// DLLCODE.H - include file used by all platforms to define macros required 
//             to build static and dynamic libraries.
//             The DLLCODE.H file is included in every include file extending
//             the visibility of the macros defined here to the every source
//             code file. 


#ifndef __DLL_CODE_H__
#define __DLL_CODE_H__

#if defined (__MSVC_DLL__) // Defines the entry point for the DLL application
//--------------------------------------------------------------------------
// The following ifdef block is the standard way of creating macros which 
// make exporting from a DLL simpler. All files within this DLL are compiled 
// with the DLL_CODE_EXPORTS  symbol defined on the command line. This 
// symbol should not be defined on any project that uses this DLL. This way 
// any other project whose source files include this file see DLL_CODE_API 
// functions as being imported from a DLL, whereas this DLL sees symbols
// defined with this macro as being exported.
//---------------------------------------------------------------------------
#ifdef DLL_CODE_EXPORTS
#define DLL_CODE_API __declspec(dllexport)
#else
#define DLL_CODE_API __declspec(dllimport)
#endif
#else // Macro used for non DLL code
#define DLL_CODE_API
#endif // __MSVC_DLL__

// Force ANSI compatibility for Visual C++ .NET
#if defined (__MSDEVNET__) && !defined (__USE_ANSI_CPP__)
#define __USE_ANSI_CPP__
#endif // __MSDEVNET__

// Force ANSI compatibility for BCC32
#if defined (__BCC32__) && !defined (__USE_ANSI_CPP__)
#define __USE_ANSI_CPP__
#endif // __BCC32__

#if defined (__USE_ANSI_CPP__)
// Macro used to define the std name space used by the ANSI 
// Standard C++ library.
#define GXSTD std
#else // Use the old Standard C++ library by default  
#define GXSTD
#endif // __USE_ANSI_CPP__

#endif // __DLL_CODE_H__
