###########################################################################
#
# win32.mak -- Windows Makefile for expat
#
# By Michael Dewsnip
#
# Copyright (C) 2010  DL Consulting Ltd.
#
###########################################################################

AR = lib
CC = cl
CPPFLAGS =
DEFS = -DCOMPILED_FROM_DSP -DXML_DTD -D_CRT_SECURE_NO_DEPRECATE
INCLUDES = 

COMPILE = $(CC) -nologo -c $(CPPFLAGS) $(DEFS) $(INCLUDES)


.SUFFIXES:
.SUFFIXES: .c .obj
.c.obj:
	$(COMPILE) $<

HEADERS = \
  expat.h

SOURCES = \
  xmlparse.c \
  xmlrole.c \
  xmltok.c \

OBJECTS = \
  xmlparse.obj \
  xmlrole.obj \
  xmltok.obj

LIBRARY = libexpat.lib

all: $(LIBRARY)

libexpat.lib: $(OBJECTS)
	if EXIST $(LIBRARY) del $(LIBRARY)
	$(AR) -nologo /out:$(LIBRARY) $(OBJECTS)

clean:
	del $(OBJECTS)
	del $(LIBRARY)

install: $(LIBRARY)
        if NOT EXIST "..\..\include" mkdir "..\..\include"
	copy *.h "..\..\include"
        if NOT EXIST "..\..\lib" mkdir "..\..\lib"
	copy $(LIBRARY) "..\..\lib"
