/**********************************************************************
 *
 * z3950parser.h -- convert Z39.50's RPN query syntax into Greenstone
 * Copyright (C) 2000  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef Z3950PARSER_H
#define Z3950PARSER_H


#include <string>
#include <list>

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>

// Greenstone headers
#include "fileutil.h"
#include "comtypes.h"
#include "nullproto.h"
#include "z3950_to_gsdl.h"

// YAZ headers
extern "C" {
#include <yaz/backend.h>
#include <yaz/log.h>
#ifdef ASN_COMPILED
#include <yaz/ill.h>
#endif
}

extern text_t gsdlhome;
extern list<FilterResponse_t> Response_tlist;
extern list<text_t> Response_tlist_colnames;
extern list<int> Response_tlist_sizes;
extern z3950Server *Server;
extern collectset *Cservers;
extern nullproto *Protocol;
extern map<text_t, gsdlCollection> Collection_map;
extern map<text_t, text_t> Resultsets;

void Z_AttributeList_parse(bend_search_rr *rr, Z_AttributeList *Z, text_t &GSQuery);

void Z_Term_parse(bend_search_rr *rr, Z_Term *Z, text_t &GSQuery);

void Z_ProximityOperator_parse(bend_search_rr *rr, Z_ProximityOperator *Z, text_t &GSQuery);

void Z_Operator_parse(bend_search_rr *rr, Z_Operator *Z, text_t &GSQuery);

void Z_Operand_parse(bend_search_rr *rr, Z_Operand *Z, text_t &GSQuery);

void Z_RPNStructure_parse(bend_search_rr *rr, Z_RPNStructure *Z, text_t &GSQuery);

text_t ZQueryToGSQuery(bend_search_rr *rr);

#endif
