/**********************************************************************
 *
 * datelistbrowserclass.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "gsdl_modules_cfg.h"
#ifdef GSDL_USE_DATELIST_BROWSER

#include "browsetoolsclass.h"
#include "datelistbrowserclass.h"
#include <assert.h>


datelistbrowserclass::datelistbrowserclass () {
}

datelistbrowserclass::~datelistbrowserclass () {
}

text_t datelistbrowserclass::get_browser_name () {
  return "DateList";
}

browserclass* datelistbrowserclass::clone()
{
  return new datelistbrowserclass();
}

void datelistbrowserclass::load_metadata_defaults (text_tset &metadata) {
  metadata.insert ("Date");
  metadata.insert ("doctype");
}

text_t datelistbrowserclass::get_default_formatstring () {
  return "<td>[link][icon][/link]</td><td>[highlight]{Or}{[dc.Title],[exp.Title],[ex.Title],Untitled}[/highlight]</td><td>{Or}{[format:dc.Date],[format:exp.Date],[format:ex.Date]}</td>";
}

int datelistbrowserclass::output_section_group (ResultDocInfo_t &/*section*/, cgiargsclass &/*args*/,
						const text_t &/*collection*/, int /*colnumber*/, 
						format_t * /*formatlistptr*/, bool /*use_table*/, 
						text_tset &/*metadata*/, bool &/*getParents*/,
						recptproto * /*collectproto*/, displayclass &/*disp*/, 
						outconvertclass &/*outconvert*/, ostream &/*textout*/, 
						ostream &/*logout*/) {
  return 0;
}

int datelistbrowserclass::output_section_group (FilterResponse_t &sections, cgiargsclass &args,
						const text_t &collection, int colnumber, format_t *formatlistptr, 
						bool use_table, text_tset &/*metadata*/, bool &/*getParents*/,
						recptproto * collectproto, displayclass &disp, 
						outconvertclass &outconvert, ostream &textout, ostream &logout) {

  browsetoolsclass btools;
  text_t lastyear = "0000";
  text_t lastmonth = "00";
  text_t tabbing, endtabbing;

  if (use_table || colnumber > 0) {
    textout << outconvert << "<table><tr><td>";
    // get tab size
    text_t tab; int itab;
    disp.expandstring (displayclass::defaultpackage, "_tabwidth_", tab);
    itab = tab.getint();
    if (colnumber > 0) 
      textout << outconvert << "<img alt=\"\" src=\"_httpiconspace_\" width=\"" << (itab*colnumber) << "\"/>";
    textout << outconvert << "</td><td>";
  }

  textout << outconvert << "<table class=\"date_list\">\n";

  ResultDocInfo_tarray::iterator thissection = sections.docInfo.begin();
  ResultDocInfo_tarray::iterator endsection = sections.docInfo.end();
  
  // use the dm arg as date metadata or else Date
  text_t date_meta = args["dm"];
  if (date_meta == "") {
    date_meta = "Date";
  }
  text_tarray dates;
  splitchar(date_meta.begin(), date_meta.end(), ',', dates);

  while (thissection != endsection) {

    text_t &doctype = (*thissection).metadata["doctype"].values[0];

    text_tarray::iterator begin = dates.begin();
    text_tarray::iterator end = dates.end();
    text_t date;
    while (begin!= end && date.empty()) {
      date = (*thissection).metadata[*begin].values[0];
      begin++;
    }
    text_t thisyear = "";
    text_t thismonth = "";
    if (!date.empty()) {
      text_t::const_iterator datebegin = date.begin();
      int datesize = date.size();
    
      if (datesize >=4) {
	thisyear = substr (datebegin, datebegin+4);
	thismonth = "00";
	int pos = 4;
	// allow for yyyy-mm-dd
	if (datesize > pos && date[pos]=='-') {
	  ++pos;
	}
	if (datesize >= pos+2)
	  thismonth = substr (datebegin+pos, datebegin+pos+2); 
      }
    }
    
    text_t link = "<a href=\"_httpdocument_&cl=";
    text_t icon = "_document:iconclosedbook_";
      
    if (doctype == "classify") {
      icon = "_document:iconclosedbookshelf_";
      link += (*thissection).OID + "\">";
    } else {
      link += args["cl"] + "&d=" + (*thissection).OID; // + "\">";
      // [modification to allow default document detach settings -- kjdon]
      if (args["xx"]=="1") {
	// documents should be detached
	link += "&x=1\" target=\\_blank>";
      } else {
	link += "\">";
      }
    }

    textout << outconvert << "<tr valign=top>";
    bool new_year = false;
    if (thisyear != "" && thisyear != lastyear) {
      textout << outconvert << "<td><span class=\"date_list_year\">" << thisyear << "</span></td>";
      lastyear = thisyear;
      new_year = true;
    } else {
      textout << outconvert << "<td></td>";
    }
    if (thismonth != "" && (thismonth != lastmonth || new_year)) {
      textout << outconvert << disp << ("<td><span class=\"date_list_month\">_textmonth" + thismonth + "_</span></td>");
      lastmonth = thismonth;
    } else {
      textout << outconvert << "<td></td>";
    }
    if (!use_table) textout << outconvert << "<td>\n";

    text_tmap options;
    options["link"] = link;
    options["icon"] = icon;
    options["highlight"] = "0";
    options["DocImage"] = btools.get_cover_image();
    options["assocfilepath"] = btools.get_assocfile_path();

    textout << outconvert << disp 
            << get_formatted_string (collection, collectproto,
				     *thissection, disp, formatlistptr, 
				     options, logout) << "\n";
    
    if (!use_table) textout << outconvert << "</td>";
    
    textout << outconvert << "</tr>\n";
    
    ++thissection;
  }

  textout << outconvert << "</table>\n";

  if (use_table  || colnumber > 0) textout << outconvert << "</td></tr></table>\n";
  return 1;
}

#endif //GSDL_USE_DATELIST_BROWSER
