/**********************************************************************
 *
 * oaitools.cpp --
 *
 * Copyright (C) 2004-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "oaitools.h"

#include "recptprototools.h"


void oaiclassifier::swapColonsAndPeriods(text_t &classifier)
{
  for (int i = 0; i < classifier.size(); ++i) {
	if (classifier[i] == '.') {
      classifier[i] = ':';
    }
    else if (classifier[i] == ':') {
      classifier[i] = '.';
    }
  }

}

text_t oaiclassifier::getGSDL_OID(const text_t &collection, const text_t& oai_id, 
				  recptproto *protocol, ostream &logout)
{
  FilterResponse_t response;
  text_tset        metadata;

  // metadata.insert("gsdl_id");

  bool status_ok = get_children(oai_id, collection, "", metadata, false, protocol, response, logout);
       // OLD: gets the ID in the 'contains' field of the index_db for OID key of type [oai.x] where x is numeric
       // Now we check the etc/oai-inf.<db> instead.
  text_t gsdl_id = "";
  if (status_ok) {
    if(response.docInfo.size() > 0){
      gsdl_id = response.docInfo[0].OID;
    }
    else {
      // Response.docInfo is empty, meaning the doc in question didn't have an oai_id number.
      return gsdl_id; // Return the empty string to indicate this.
    }
  }

  return gsdl_id;
}

/**
 *  Called to convert GS classifier/document identifiers that use
 *  a '.' to separate levels in the hierarchy into OAI identifiers
 *  that use ':' instead.
 */
void oaiclassifier::toOAI(const text_t repos_id, const text_t &collection, text_t &classifier)
{
 
  text_t tmp = "oai:";
  tmp.append(repos_id);
  tmp.append(":");
  tmp.append(collection);
  toOAI(tmp, classifier);

}

/**
 *  Called to convert GS classifier/document identifiers that use
 *  a '.' to separate levels in the hierarchy into OAI identifiers
 *  that use ':' instead.
 */
void oaiclassifier::toOAI(const text_t &collection, text_t &classifier)
{
  oaiclassifier::swapColonsAndPeriods(classifier);

  // prepend the collection identifier to the beginning of the
  // OAI identifier.
  text_t tmp = collection;
  tmp.append(":");
  tmp.append(classifier);
  
  classifier = tmp;
}

void  oaiclassifier::getCollectionFromOAIID(const text_t oai_id, text_t &collection_id) {

  // id is like oai:repos-id:collection:OID, we just want the collection bit

  text_t::const_iterator begin = oai_id.begin();
  text_t::const_iterator end = oai_id.end();
  text_t::const_iterator colon = findchar(begin, end, ':'); // 1
  if (colon != end) {
    colon = findchar(colon+1, end, ':'); // 2
  }
  text_t::const_iterator third_colon;
  if (colon !=end) {
    third_colon = findchar(colon+1, end, ':');
  }
  if (third_colon != end) {
    collection_id = substr(colon+1, third_colon);
  }
}

/**
 *  Called to convert OAI classifier/document identifiers that use
 *  a ':' to separate levels in the hierarchy into GS identifiers
 *  that use '.' instead.
 */
void oaiclassifier::toGSDL(text_t &collection, text_t &classifier)
{
  oaiclassifier::swapColonsAndPeriods(classifier);

  // separate out the collection identifier that should be
  // found at the beginning of the OAI identifier from the
  // item identifier within the collection
  text_t::iterator colon = find(classifier.begin(), classifier.end(), '.');
  if (colon != classifier.end()) {
    collection = substr(classifier.begin(), colon);
    classifier = substr(colon + 1, classifier.end());
  }
  else{
    collection = classifier;
    classifier = "";
  }
}
